
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.Required;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "kernel",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
@XmlRootElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_3")
public class SupportVectorMachineModel
    extends Model
    implements HasExtensions<SupportVectorMachineModel>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "threshold")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private Double threshold;
    @XmlAttribute(name = "svmRepresentation")
    private SupportVectorMachineModel.Representation representation;
    @XmlAttribute(name = "alternateBinaryTargetCategory")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @Removed((org.dmg.pmml.Version.PMML_4_0))
    private String alternateBinaryTargetCategory;
    @XmlAttribute(name = "classificationMethod")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private SupportVectorMachineModel.ClassificationMethod classificationMethod;
    @XmlAttribute(name = "maxWins")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
    private Boolean maxWins;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElements({
        @XmlElement(name = "LinearKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = LinearKernel.class),
        @XmlElement(name = "PolynomialKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = PolynomialKernel.class),
        @XmlElement(name = "RadialBasisKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = RadialBasisKernel.class),
        @XmlElement(name = "SigmoidKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = SigmoidKernel.class)
    })
    private Kernel kernel;
    @XmlElement(name = "VectorDictionary", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @Required((org.dmg.pmml.Version.PMML_3_1))
    private VectorDictionary vectorDictionary;
    @XmlElement(name = "SupportVectorMachine", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Double DEFAULT_THRESHOLD = 0.0D;
    private final static Boolean DEFAULT_MAX_WINS = false;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305483L;

    public SupportVectorMachineModel() {
    }

    public SupportVectorMachineModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("vectorDictionary")
        VectorDictionary vectorDictionary,
        @org.jpmml.model.annotations.Property("supportVectorMachines")
        List<SupportVectorMachine> supportVectorMachines) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.vectorDictionary = vectorDictionary;
        this.supportVectorMachines = supportVectorMachines;
    }

    public String getModelName() {
        return modelName;
    }

    public SupportVectorMachineModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public SupportVectorMachineModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public SupportVectorMachineModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Double getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    public SupportVectorMachineModel setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public SupportVectorMachineModel.Representation getRepresentation() {
        if (representation == null) {
            return SupportVectorMachineModel.Representation.SUPPORT_VECTORS;
        } else {
            return representation;
        }
    }

    public SupportVectorMachineModel setRepresentation(
        @org.jpmml.model.annotations.Property("representation")
        SupportVectorMachineModel.Representation representation) {
        this.representation = representation;
        return this;
    }

    public String getAlternateBinaryTargetCategory() {
        return alternateBinaryTargetCategory;
    }

    public SupportVectorMachineModel setAlternateBinaryTargetCategory(
        @org.jpmml.model.annotations.Property("alternateBinaryTargetCategory")
        String alternateBinaryTargetCategory) {
        this.alternateBinaryTargetCategory = alternateBinaryTargetCategory;
        return this;
    }

    public SupportVectorMachineModel.ClassificationMethod getClassificationMethod() {
        if (classificationMethod == null) {
            return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ALL;
        } else {
            return classificationMethod;
        }
    }

    public SupportVectorMachineModel setClassificationMethod(
        @org.jpmml.model.annotations.Property("classificationMethod")
        SupportVectorMachineModel.ClassificationMethod classificationMethod) {
        this.classificationMethod = classificationMethod;
        return this;
    }

    public boolean isMaxWins() {
        if (maxWins == null) {
            return DEFAULT_MAX_WINS;
        } else {
            return maxWins;
        }
    }

    public SupportVectorMachineModel setMaxWins(
        @org.jpmml.model.annotations.Property("maxWins")
        Boolean maxWins) {
        this.maxWins = maxWins;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public SupportVectorMachineModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public SupportVectorMachineModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public SupportVectorMachineModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public SupportVectorMachineModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public SupportVectorMachineModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public SupportVectorMachineModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public SupportVectorMachineModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public SupportVectorMachineModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Kernel getKernel() {
        return kernel;
    }

    public SupportVectorMachineModel setKernel(
        @org.jpmml.model.annotations.Property("kernel")
        Kernel kernel) {
        this.kernel = kernel;
        return this;
    }

    public VectorDictionary getVectorDictionary() {
        return vectorDictionary;
    }

    public SupportVectorMachineModel setVectorDictionary(
        @org.jpmml.model.annotations.Property("vectorDictionary")
        VectorDictionary vectorDictionary) {
        this.vectorDictionary = vectorDictionary;
        return this;
    }

    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (supportVectorMachines == null) {
            supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public SupportVectorMachineModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SupportVectorMachineModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSupportVectorMachines() {
        return ((this.supportVectorMachines!= null)&&(this.supportVectorMachines.size()> 0));
    }

    public SupportVectorMachineModel addSupportVectorMachines(SupportVectorMachine... supportVectorMachines) {
        getSupportVectorMachines().addAll(Arrays.asList(supportVectorMachines));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getKernel(), getVectorDictionary());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSupportVectorMachines()) {
                status = PMMLObject.traverse(visitor, getSupportVectorMachines());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum ClassificationMethod {

        @XmlEnumValue("OneAgainstAll")
        ONE_AGAINST_ALL("OneAgainstAll"),
        @XmlEnumValue("OneAgainstOne")
        ONE_AGAINST_ONE("OneAgainstOne");
        private final String value;

        ClassificationMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static SupportVectorMachineModel.ClassificationMethod fromValue(String v) {
            for (SupportVectorMachineModel.ClassificationMethod c: SupportVectorMachineModel.ClassificationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum Representation {

        @XmlEnumValue("SupportVectors")
        SUPPORT_VECTORS("SupportVectors"),
        @XmlEnumValue("Coefficients")
        COEFFICIENTS("Coefficients");
        private final String value;

        Representation(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static SupportVectorMachineModel.Representation fromValue(String v) {
            for (SupportVectorMachineModel.Representation c: SupportVectorMachineModel.Representation.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
