
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "anovaRows"
})
@XmlRootElement(name = "Anova", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
public class Anova
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Anova>
{

    @XmlAttribute(name = "target")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName target;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "AnovaRow", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<AnovaRow> anovaRows;
    private final static long serialVersionUID = 67305483L;

    public Anova() {
    }

    public Anova(
        @org.jpmml.model.annotations.Property("anovaRows")
        List<AnovaRow> anovaRows) {
        this.anovaRows = anovaRows;
    }

    public FieldName getTarget() {
        return target;
    }

    public Anova setTarget(
        @org.jpmml.model.annotations.Property("target")
        FieldName target) {
        this.target = target;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<AnovaRow> getAnovaRows() {
        if (anovaRows == null) {
            anovaRows = new ArrayList<AnovaRow>();
        }
        return this.anovaRows;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Anova addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasAnovaRows() {
        return ((this.anovaRows!= null)&&(this.anovaRows.size()> 0));
    }

    public Anova addAnovaRows(AnovaRow... anovaRows) {
        getAnovaRows().addAll(Arrays.asList(anovaRows));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasAnovaRows()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAnovaRows());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
