
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "quantiles"
})
@XmlRootElement(name = "NumericInfo", namespace = "http://www.dmg.org/PMML-4_3")
public class NumericInfo
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<NumericInfo>
{

    @XmlAttribute(name = "minimum")
    private Double minimum;
    @XmlAttribute(name = "maximum")
    private Double maximum;
    @XmlAttribute(name = "mean")
    private Double mean;
    @XmlAttribute(name = "standardDeviation")
    private Double standardDeviation;
    @XmlAttribute(name = "median")
    private Double median;
    @XmlAttribute(name = "interQuartileRange")
    private Double interQuartileRange;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Quantile", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Quantile> quantiles;
    private final static long serialVersionUID = 67305483L;

    public Double getMinimum() {
        return minimum;
    }

    public NumericInfo setMinimum(
        @Property("minimum")
        Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Double getMaximum() {
        return maximum;
    }

    public NumericInfo setMaximum(
        @Property("maximum")
        Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public Double getMean() {
        return mean;
    }

    public NumericInfo setMean(
        @Property("mean")
        Double mean) {
        this.mean = mean;
        return this;
    }

    public Double getStandardDeviation() {
        return standardDeviation;
    }

    public NumericInfo setStandardDeviation(
        @Property("standardDeviation")
        Double standardDeviation) {
        this.standardDeviation = standardDeviation;
        return this;
    }

    public Double getMedian() {
        return median;
    }

    public NumericInfo setMedian(
        @Property("median")
        Double median) {
        this.median = median;
        return this;
    }

    public Double getInterQuartileRange() {
        return interQuartileRange;
    }

    public NumericInfo setInterQuartileRange(
        @Property("interQuartileRange")
        Double interQuartileRange) {
        this.interQuartileRange = interQuartileRange;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Quantile> getQuantiles() {
        if (quantiles == null) {
            quantiles = new ArrayList<Quantile>();
        }
        return this.quantiles;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NumericInfo addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasQuantiles() {
        return ((this.quantiles!= null)&&(this.quantiles.size()> 0));
    }

    public NumericInfo addQuantiles(Quantile... quantiles) {
        getQuantiles().addAll(Arrays.asList(quantiles));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasQuantiles()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getQuantiles());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
