
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValues"
})
@XmlRootElement(name = "Target", namespace = "http://www.dmg.org/PMML-4_3")
public class Target
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Target> , HasFieldReference<Target> , HasOpType<Target> , Indexable<org.dmg.pmml.FieldName>
{

    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Optional((org.dmg.pmml.Version.PMML_4_3))
    private org.dmg.pmml.FieldName field;
    @XmlAttribute(name = "optype")
    private OpType opType;
    @XmlAttribute(name = "castInteger")
    private Target.CastInteger castInteger;
    @XmlAttribute(name = "min")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Double min;
    @XmlAttribute(name = "max")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Double max;
    @XmlAttribute(name = "rescaleConstant")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Double rescaleConstant;
    @XmlAttribute(name = "rescaleFactor")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Double rescaleFactor;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValue", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Optional((org.dmg.pmml.Version.PMML_3_1))
    private List<TargetValue> targetValues;
    private final static Double DEFAULT_RESCALE_CONSTANT = 0.0D;
    private final static Double DEFAULT_RESCALE_FACTOR = 1.0D;
    private final static long serialVersionUID = 67305483L;

    public org.dmg.pmml.FieldName getField() {
        return field;
    }

    public Target setField(
        @Property("field")
        org.dmg.pmml.FieldName field) {
        this.field = field;
        return this;
    }

    public OpType getOpType() {
        return opType;
    }

    public Target setOpType(
        @Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    public Target.CastInteger getCastInteger() {
        return castInteger;
    }

    public Target setCastInteger(
        @Property("castInteger")
        Target.CastInteger castInteger) {
        this.castInteger = castInteger;
        return this;
    }

    public Double getMin() {
        return min;
    }

    public Target setMin(
        @Property("min")
        Double min) {
        this.min = min;
        return this;
    }

    public Double getMax() {
        return max;
    }

    public Target setMax(
        @Property("max")
        Double max) {
        this.max = max;
        return this;
    }

    public Double getRescaleConstant() {
        if (rescaleConstant == null) {
            return DEFAULT_RESCALE_CONSTANT;
        } else {
            return rescaleConstant;
        }
    }

    public Target setRescaleConstant(
        @Property("rescaleConstant")
        Double rescaleConstant) {
        this.rescaleConstant = rescaleConstant;
        return this;
    }

    public Double getRescaleFactor() {
        if (rescaleFactor == null) {
            return DEFAULT_RESCALE_FACTOR;
        } else {
            return rescaleFactor;
        }
    }

    public Target setRescaleFactor(
        @Property("rescaleFactor")
        Double rescaleFactor) {
        this.rescaleFactor = rescaleFactor;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<TargetValue> getTargetValues() {
        if (targetValues == null) {
            targetValues = new ArrayList<TargetValue>();
        }
        return this.targetValues;
    }

    @Override
    public org.dmg.pmml.FieldName getKey() {
        return getField();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Target addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTargetValues() {
        return ((this.targetValues!= null)&&(this.targetValues.size()> 0));
    }

    public Target addTargetValues(TargetValue... targetValues) {
        getTargetValues().addAll(Arrays.asList(targetValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTargetValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CastInteger {

        @XmlEnumValue("round")
        ROUND("round"),
        @XmlEnumValue("ceiling")
        CEILING("ceiling"),
        @XmlEnumValue("floor")
        FLOOR("floor");
        private final String value;

        CastInteger(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Target.CastInteger fromValue(String v) {
            for (Target.CastInteger c: Target.CastInteger.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
