
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_3")
public class Aggregate
    extends Expression
    implements HasExtensions<Aggregate> , HasFieldReference<Aggregate>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "function", required = true)
    private Aggregate.Function function;
    @XmlAttribute(name = "groupField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName groupField;
    @XmlAttribute(name = "sqlWhere")
    private String sqlWhere;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305483L;

    public Aggregate() {
    }

    public Aggregate(
        @org.jpmml.model.annotations.Property("field")
        FieldName field,
        @org.jpmml.model.annotations.Property("function")
        Aggregate.Function function) {
        this.field = field;
        this.function = function;
    }

    public FieldName getField() {
        return field;
    }

    public Aggregate setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public Aggregate.Function getFunction() {
        return function;
    }

    public Aggregate setFunction(
        @org.jpmml.model.annotations.Property("function")
        Aggregate.Function function) {
        this.function = function;
        return this;
    }

    public FieldName getGroupField() {
        return groupField;
    }

    public Aggregate setGroupField(
        @org.jpmml.model.annotations.Property("groupField")
        FieldName groupField) {
        this.groupField = groupField;
        return this;
    }

    public String getSqlWhere() {
        return sqlWhere;
    }

    public Aggregate setSqlWhere(
        @org.jpmml.model.annotations.Property("sqlWhere")
        String sqlWhere) {
        this.sqlWhere = sqlWhere;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Aggregate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Function {

        @XmlEnumValue("count")
        COUNT("count"),
        @XmlEnumValue("sum")
        SUM("sum"),
        @XmlEnumValue("average")
        AVERAGE("average"),
        @XmlEnumValue("min")
        MIN("min"),
        @XmlEnumValue("max")
        MAX("max"),
        @XmlEnumValue("multiset")
        MULTISET("multiset");
        private final String value;

        Function(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Aggregate.Function fromValue(String v) {
            for (Aggregate.Function c: Aggregate.Function.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
