
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "ClusteringModelQuality", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
public class ClusteringModelQuality
    extends PMMLObject
{

    @XmlAttribute(name = "dataName")
    private String dataName;
    @XmlAttribute(name = "SSE")
    private Double sse;
    @XmlAttribute(name = "SSB")
    private Double ssb;
    private final static long serialVersionUID = 67305483L;

    public String getDataName() {
        return dataName;
    }

    public ClusteringModelQuality setDataName(
        @Property("dataName")
        String dataName) {
        this.dataName = dataName;
        return this;
    }

    public Double getSSE() {
        return sse;
    }

    public ClusteringModelQuality setSSE(
        @Property("sse")
        Double sse) {
        this.sse = sse;
        return this;
    }

    public Double getSSB() {
        return ssb;
    }

    public ClusteringModelQuality setSSB(
        @Property("ssb")
        Double ssb) {
        this.ssb = ssb;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
