
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "parameterFields",
    "expression"
})
@XmlRootElement(name = "DefineFunction", namespace = "http://www.dmg.org/PMML-4_3")
public class DefineFunction
    extends org.dmg.pmml.PMMLObject
    implements HasExpression<DefineFunction> , HasExtensions<DefineFunction> , HasType<DefineFunction> , Indexable<String>
{

    @XmlAttribute(name = "name", required = true)
    private String name;
    @XmlAttribute(name = "optype", required = true)
    private OpType opType;
    @XmlAttribute(name = "dataType")
    private DataType dataType;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "ParameterField", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<ParameterField> parameterFields;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_3", type = Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_3", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_3", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_3", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_3", type = Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_3", type = MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_3", type = TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_3", type = Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_3", type = Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_3", type = Lag.class)
    })
    private Expression expression;
    private final static long serialVersionUID = 67305483L;

    public DefineFunction() {
    }

    public DefineFunction(
        @org.jpmml.model.annotations.Property("name")
        String name,
        @org.jpmml.model.annotations.Property("opType")
        OpType opType,
        @org.jpmml.model.annotations.Property("parameterFields")
        List<ParameterField> parameterFields) {
        this.name = name;
        this.opType = opType;
        this.parameterFields = parameterFields;
    }

    public String getName() {
        return name;
    }

    public DefineFunction setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public OpType getOpType() {
        return opType;
    }

    public DefineFunction setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    public DataType getDataType() {
        return dataType;
    }

    public DefineFunction setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<ParameterField> getParameterFields() {
        if (parameterFields == null) {
            parameterFields = new ArrayList<ParameterField>();
        }
        return this.parameterFields;
    }

    public Expression getExpression() {
        return expression;
    }

    public DefineFunction setExpression(
        @org.jpmml.model.annotations.Property("expression")
        Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public String getKey() {
        return getName();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public DefineFunction addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasParameterFields() {
        return ((this.parameterFields!= null)&&(this.parameterFields.size()> 0));
    }

    public DefineFunction addParameterFields(ParameterField... parameterFields) {
        getParameterFields().addAll(Arrays.asList(parameterFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasParameterFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getParameterFields());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
