
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValueStats"
})
@XmlRootElement(name = "TargetValueStats", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_2))
public class TargetValueStats
    extends org.dmg.pmml.PMMLObject
    implements Iterable<TargetValueStat> , HasExtensions<TargetValueStats>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValueStat", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<TargetValueStat> targetValueStats;
    private final static long serialVersionUID = 67305483L;

    public TargetValueStats() {
    }

    public TargetValueStats(
        @Property("targetValueStats")
        List<TargetValueStat> targetValueStats) {
        this.targetValueStats = targetValueStats;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<TargetValueStat> getTargetValueStats() {
        if (targetValueStats == null) {
            targetValueStats = new ArrayList<TargetValueStat>();
        }
        return this.targetValueStats;
    }

    public Iterator<TargetValueStat> iterator() {
        return getTargetValueStats().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TargetValueStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTargetValueStats() {
        return ((this.targetValueStats!= null)&&(this.targetValueStats.size()> 0));
    }

    public TargetValueStats addTargetValueStats(TargetValueStat... targetValueStats) {
        getTargetValueStats().addAll(Arrays.asList(targetValueStats));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTargetValueStats()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValueStats());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
