
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "trainingInstances",
    "comparisonMeasure",
    "knnInputs",
    "modelVerification"
})
@XmlRootElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_3")
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
public class NearestNeighborModel
    extends Model
    implements HasExtensions<NearestNeighborModel>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfNeighbors", required = true)
    private int numberOfNeighbors;
    @XmlAttribute(name = "continuousScoringMethod")
    private NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod;
    @XmlAttribute(name = "categoricalScoringMethod")
    private NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod;
    @XmlAttribute(name = "instanceIdVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName instanceIdVariable;
    @XmlAttribute(name = "threshold")
    private Double threshold;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private TrainingInstances trainingInstances;
    @XmlElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "KNNInputs", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private KNNInputs knnInputs;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Double DEFAULT_THRESHOLD = 0.001D;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305483L;

    public NearestNeighborModel() {
    }

    public NearestNeighborModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("numberOfNeighbors")
        int numberOfNeighbors,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("trainingInstances")
        TrainingInstances trainingInstances,
        @org.jpmml.model.annotations.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure,
        @org.jpmml.model.annotations.Property("knnInputs")
        KNNInputs knnInputs) {
        this.miningFunction = miningFunction;
        this.numberOfNeighbors = numberOfNeighbors;
        this.miningSchema = miningSchema;
        this.trainingInstances = trainingInstances;
        this.comparisonMeasure = comparisonMeasure;
        this.knnInputs = knnInputs;
    }

    public String getModelName() {
        return modelName;
    }

    public NearestNeighborModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public NearestNeighborModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public NearestNeighborModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public int getNumberOfNeighbors() {
        return numberOfNeighbors;
    }

    public NearestNeighborModel setNumberOfNeighbors(
        @org.jpmml.model.annotations.Property("numberOfNeighbors")
        int numberOfNeighbors) {
        this.numberOfNeighbors = numberOfNeighbors;
        return this;
    }

    public NearestNeighborModel.ContinuousScoringMethod getContinuousScoringMethod() {
        if (continuousScoringMethod == null) {
            return NearestNeighborModel.ContinuousScoringMethod.AVERAGE;
        } else {
            return continuousScoringMethod;
        }
    }

    public NearestNeighborModel setContinuousScoringMethod(
        @org.jpmml.model.annotations.Property("continuousScoringMethod")
        NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod) {
        this.continuousScoringMethod = continuousScoringMethod;
        return this;
    }

    public NearestNeighborModel.CategoricalScoringMethod getCategoricalScoringMethod() {
        if (categoricalScoringMethod == null) {
            return NearestNeighborModel.CategoricalScoringMethod.MAJORITY_VOTE;
        } else {
            return categoricalScoringMethod;
        }
    }

    public NearestNeighborModel setCategoricalScoringMethod(
        @org.jpmml.model.annotations.Property("categoricalScoringMethod")
        NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod) {
        this.categoricalScoringMethod = categoricalScoringMethod;
        return this;
    }

    public FieldName getInstanceIdVariable() {
        return instanceIdVariable;
    }

    public NearestNeighborModel setInstanceIdVariable(
        @org.jpmml.model.annotations.Property("instanceIdVariable")
        FieldName instanceIdVariable) {
        this.instanceIdVariable = instanceIdVariable;
        return this;
    }

    public Double getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    public NearestNeighborModel setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public NearestNeighborModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public NearestNeighborModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public NearestNeighborModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public NearestNeighborModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public NearestNeighborModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public NearestNeighborModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public NearestNeighborModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public NearestNeighborModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TrainingInstances getTrainingInstances() {
        return trainingInstances;
    }

    public NearestNeighborModel setTrainingInstances(
        @org.jpmml.model.annotations.Property("trainingInstances")
        TrainingInstances trainingInstances) {
        this.trainingInstances = trainingInstances;
        return this;
    }

    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    public NearestNeighborModel setComparisonMeasure(
        @org.jpmml.model.annotations.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    public KNNInputs getKNNInputs() {
        return knnInputs;
    }

    public NearestNeighborModel setKNNInputs(
        @org.jpmml.model.annotations.Property("knnInputs")
        KNNInputs knnInputs) {
        this.knnInputs = knnInputs;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public NearestNeighborModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NearestNeighborModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getTrainingInstances(), getComparisonMeasure(), getKNNInputs(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CategoricalScoringMethod {

        @XmlEnumValue("majorityVote")
        MAJORITY_VOTE("majorityVote"),
        @XmlEnumValue("weightedMajorityVote")
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote");
        private final String value;

        CategoricalScoringMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static NearestNeighborModel.CategoricalScoringMethod fromValue(String v) {
            for (NearestNeighborModel.CategoricalScoringMethod c: NearestNeighborModel.CategoricalScoringMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum ContinuousScoringMethod {

        @XmlEnumValue("median")
        MEDIAN("median"),
        @XmlEnumValue("average")
        AVERAGE("average"),
        @XmlEnumValue("weightedAverage")
        WEIGHTED_AVERAGE("weightedAverage");
        private final String value;

        ContinuousScoringMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static NearestNeighborModel.ContinuousScoringMethod fromValue(String v) {
            for (NearestNeighborModel.ContinuousScoringMethod c: NearestNeighborModel.ContinuousScoringMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
