
package org.dmg.pmml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "textDocuments"
})
@XmlRootElement(name = "TextCorpus", namespace = "http://www.dmg.org/PMML-4_3")
public class TextCorpus
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TextCorpus>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "TextDocument", namespace = "http://www.dmg.org/PMML-4_3")
    private List<TextDocument> textDocuments;
    private final static long serialVersionUID = 67305483L;

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<TextDocument> getTextDocuments() {
        if (textDocuments == null) {
            textDocuments = new ArrayList<TextDocument>();
        }
        return this.textDocuments;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TextCorpus addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTextDocuments() {
        return ((this.textDocuments!= null)&&(this.textDocuments.size()> 0));
    }

    public TextCorpus addTextDocuments(TextDocument... textDocuments) {
        getTextDocuments().addAll(Arrays.asList(textDocuments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTextDocuments()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTextDocuments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
