
package org.dmg.pmml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasId;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "TextDocument", namespace = "http://www.dmg.org/PMML-4_3")
public class TextDocument
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TextDocument> , HasId<TextDocument> , Indexable<String>
{

    @XmlAttribute(name = "id", required = true)
    private String id;
    @XmlAttribute(name = "name")
    private String name;
    @XmlAttribute(name = "length")
    private Integer length;
    @XmlAttribute(name = "file")
    private String file;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305483L;

    public TextDocument() {
    }

    public TextDocument(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public TextDocument setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public TextDocument setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public Integer getLength() {
        return length;
    }

    public TextDocument setLength(
        @org.jpmml.model.annotations.Property("length")
        Integer length) {
        this.length = length;
        return this;
    }

    public String getFile() {
        return file;
    }

    public TextDocument setFile(
        @org.jpmml.model.annotations.Property("file")
        String file) {
        this.file = file;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public String getKey() {
        return getId();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TextDocument addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
