
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "indices",
    "entries"
})
@XmlRootElement(name = "INT-SparseArray", namespace = "http://www.dmg.org/PMML-4_3")
public class IntSparseArray
    extends SparseArray<Integer>
{

    @XmlAttribute(name = "n")
    private Integer n;
    @XmlAttribute(name = "defaultValue")
    private Integer defaultValue;
    @XmlList
    @XmlElement(name = "Indices", namespace = "http://www.dmg.org/PMML-4_3", type = Integer.class)
    private List<Integer> indices;
    @XmlList
    @XmlElement(name = "INT-Entries", namespace = "http://www.dmg.org/PMML-4_3", type = Integer.class)
    private List<Integer> entries;
    private final static Integer DEFAULT_DEFAULT_VALUE = 0;
    private final static long serialVersionUID = 67305483L;

    public Integer getN() {
        return n;
    }

    public IntSparseArray setN(
        @Property("n")
        Integer n) {
        this.n = n;
        return this;
    }

    public Integer getDefaultValue() {
        if (defaultValue == null) {
            return DEFAULT_DEFAULT_VALUE;
        } else {
            return defaultValue;
        }
    }

    public IntSparseArray setDefaultValue(
        @Property("defaultValue")
        Integer defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public List<Integer> getIndices() {
        if (indices == null) {
            indices = new ArrayList<Integer>();
        }
        return this.indices;
    }

    public List<Integer> getEntries() {
        if (entries == null) {
            entries = new ArrayList<Integer>();
        }
        return this.entries;
    }

    public boolean hasIndices() {
        return ((this.indices!= null)&&(this.indices.size()> 0));
    }

    public IntSparseArray addIndices(Integer... indices) {
        getIndices().addAll(Arrays.asList(indices));
        return this;
    }

    public boolean hasEntries() {
        return ((this.entries!= null)&&(this.entries.size()> 0));
    }

    public IntSparseArray addEntries(Integer... entries) {
        getEntries().addAll(Arrays.asList(entries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
