
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "value"
})
@XmlRootElement(name = "MatCell", namespace = "http://www.dmg.org/PMML-4_3")
public class MatCell
    extends PMMLObject
{

    @XmlAttribute(name = "row", required = true)
    private int row;
    @XmlAttribute(name = "col", required = true)
    private int col;
    @XmlValue
    @XmlValueExtension
    private String value;
    private final static long serialVersionUID = 67305483L;

    public MatCell() {
    }

    public MatCell(
        @org.jpmml.model.annotations.Property("row")
        int row,
        @org.jpmml.model.annotations.Property("col")
        int col,
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.row = row;
        this.col = col;
        this.value = value;
    }

    public int getRow() {
        return row;
    }

    public MatCell setRow(
        @org.jpmml.model.annotations.Property("row")
        int row) {
        this.row = row;
        return this;
    }

    public int getCol() {
        return col;
    }

    public MatCell setCol(
        @org.jpmml.model.annotations.Property("col")
        int col) {
        this.col = col;
        return this;
    }

    public String getValue() {
        return value;
    }

    public MatCell setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
