
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Quantile", namespace = "http://www.dmg.org/PMML-4_3")
public class Quantile
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Quantile>
{

    @XmlAttribute(name = "quantileLimit", required = true)
    private double quantileLimit;
    @XmlAttribute(name = "quantileValue", required = true)
    private double quantileValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305483L;

    public Quantile() {
    }

    public Quantile(
        @org.jpmml.model.annotations.Property("quantileLimit")
        double quantileLimit,
        @org.jpmml.model.annotations.Property("quantileValue")
        double quantileValue) {
        this.quantileLimit = quantileLimit;
        this.quantileValue = quantileValue;
    }

    public double getQuantileLimit() {
        return quantileLimit;
    }

    public Quantile setQuantileLimit(
        @org.jpmml.model.annotations.Property("quantileLimit")
        double quantileLimit) {
        this.quantileLimit = quantileLimit;
        return this;
    }

    public double getQuantileValue() {
        return quantileValue;
    }

    public Quantile setQuantileValue(
        @org.jpmml.model.annotations.Property("quantileValue")
        double quantileValue) {
        this.quantileValue = quantileValue;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Quantile addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
