
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "partition"
})
@XmlRootElement(name = "TargetValue", namespace = "http://www.dmg.org/PMML-4_3")
public class TargetValue
    extends org.dmg.pmml.PMMLObject
    implements HasDisplayValue<TargetValue> , HasExtensions<TargetValue>
{

    @XmlAttribute(name = "value")
    private String value;
    @XmlAttribute(name = "displayValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private String displayValue;
    @XmlAttribute(name = "priorProbability")
    private Double priorProbability;
    @XmlAttribute(name = "defaultValue")
    private Double defaultValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private Partition partition;
    private final static long serialVersionUID = 67305483L;

    public String getValue() {
        return value;
    }

    public TargetValue setValue(
        @Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public String getDisplayValue() {
        return displayValue;
    }

    public TargetValue setDisplayValue(
        @Property("displayValue")
        String displayValue) {
        this.displayValue = displayValue;
        return this;
    }

    public Double getPriorProbability() {
        return priorProbability;
    }

    public TargetValue setPriorProbability(
        @Property("priorProbability")
        Double priorProbability) {
        this.priorProbability = priorProbability;
        return this;
    }

    public Double getDefaultValue() {
        return defaultValue;
    }

    public TargetValue setDefaultValue(
        @Property("defaultValue")
        Double defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Partition getPartition() {
        return partition;
    }

    public TargetValue setPartition(
        @Property("partition")
        Partition partition) {
        this.partition = partition;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TargetValue addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPartition());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
