
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "KNNInput", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
public class KNNInput
    extends ComparisonField<KNNInput>
    implements HasExtensions<KNNInput>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "fieldWeight")
    private Double fieldWeight;
    @XmlAttribute(name = "compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static Double DEFAULT_FIELD_WEIGHT = 1.0D;
    private final static long serialVersionUID = 67305483L;

    public KNNInput() {
    }

    public KNNInput(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    public FieldName getField() {
        return field;
    }

    public KNNInput setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public Double getFieldWeight() {
        if (fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        } else {
            return fieldWeight;
        }
    }

    public KNNInput setFieldWeight(
        @org.jpmml.model.annotations.Property("fieldWeight")
        Double fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    public CompareFunction getCompareFunction() {
        return compareFunction;
    }

    public KNNInput setCompareFunction(
        @org.jpmml.model.annotations.Property("compareFunction")
        CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public KNNInput addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
