
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasId;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "setReference",
    "content",
    "time"
})
@XmlRootElement(name = "Sequence", namespace = "http://www.dmg.org/PMML-4_3")
public class Sequence
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Sequence> , HasId<Sequence> , Indexable<String>
{

    @XmlAttribute(name = "id", required = true)
    private String id;
    @XmlAttribute(name = "numberOfSets")
    private Integer numberOfSets;
    @XmlAttribute(name = "occurrence")
    private Integer occurrence;
    @XmlAttribute(name = "support")
    private Double support;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "SetReference", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private SetReference setReference;
    @XmlElements({
        @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3", type = Extension.class),
        @XmlElement(name = "Delimiter", namespace = "http://www.dmg.org/PMML-4_3", type = Delimiter.class),
        @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_3", type = Time.class),
        @XmlElement(name = "SetReference", namespace = "http://www.dmg.org/PMML-4_3", type = SetReference.class)
    })
    private List<org.dmg.pmml.PMMLObject> content;
    @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_3")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    private Time time;
    private final static long serialVersionUID = 67305483L;

    public Sequence() {
    }

    public Sequence(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("setReference")
        SetReference setReference) {
        this.id = id;
        this.setReference = setReference;
    }

    public String getId() {
        return id;
    }

    public Sequence setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public Integer getNumberOfSets() {
        return numberOfSets;
    }

    public Sequence setNumberOfSets(
        @org.jpmml.model.annotations.Property("numberOfSets")
        Integer numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    public Integer getOccurrence() {
        return occurrence;
    }

    public Sequence setOccurrence(
        @org.jpmml.model.annotations.Property("occurrence")
        Integer occurrence) {
        this.occurrence = occurrence;
        return this;
    }

    public Double getSupport() {
        return support;
    }

    public Sequence setSupport(
        @org.jpmml.model.annotations.Property("support")
        Double support) {
        this.support = support;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public SetReference getSetReference() {
        return setReference;
    }

    public Sequence setSetReference(
        @org.jpmml.model.annotations.Property("setReference")
        SetReference setReference) {
        this.setReference = setReference;
        return this;
    }

    public List<org.dmg.pmml.PMMLObject> getContent() {
        if (content == null) {
            content = new ArrayList<org.dmg.pmml.PMMLObject>();
        }
        return this.content;
    }

    public Time getTime() {
        return time;
    }

    public Sequence setTime(
        @org.jpmml.model.annotations.Property("time")
        Time time) {
        this.time = time;
        return this;
    }

    @Override
    public String getKey() {
        return getId();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Sequence addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    public Sequence addContent(org.dmg.pmml.PMMLObject... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSetReference());
            }
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContent());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTime());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
