
package org.dmg.pmml.mining;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Removed;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "localTransformations",
    "segments"
})
@XmlRootElement(name = "Segmentation", namespace = "http://www.dmg.org/PMML-4_3")
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "multipleModelMethod",
    "missingPredictionTreatment",
    "missingThreshold",
    "extensions",
    "localTransformations",
    "segments"
})
public class Segmentation
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Segmentation>
{

    @XmlAttribute(name = "multipleModelMethod", required = true)
    @JsonProperty("multipleModelMethod")
    private Segmentation.MultipleModelMethod multipleModelMethod;
    @XmlAttribute(name = "x-missingPredictionTreatment")
    @org.jpmml.model.annotations.Extension
    @JsonProperty("x-missingPredictionTreatment")
    private Segmentation.MissingPredictionTreatment missingPredictionTreatment;
    @XmlAttribute(name = "x-missingThreshold")
    @org.jpmml.model.annotations.Extension
    @JsonProperty("x-missingThreshold")
    private Double missingThreshold;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    @Removed((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Segment", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Segment")
    private List<Segment> segments;
    private final static Double DEFAULT_MISSING_THRESHOLD = 1.0D;
    private final static long serialVersionUID = 67305484L;

    public Segmentation() {
    }

    public Segmentation(
        @org.jpmml.model.annotations.Property("multipleModelMethod")
        Segmentation.MultipleModelMethod multipleModelMethod,
        @org.jpmml.model.annotations.Property("segments")
        List<Segment> segments) {
        this.multipleModelMethod = multipleModelMethod;
        this.segments = segments;
    }

    public Segmentation.MultipleModelMethod getMultipleModelMethod() {
        return multipleModelMethod;
    }

    public Segmentation setMultipleModelMethod(
        @org.jpmml.model.annotations.Property("multipleModelMethod")
        Segmentation.MultipleModelMethod multipleModelMethod) {
        this.multipleModelMethod = multipleModelMethod;
        return this;
    }

    public Segmentation.MissingPredictionTreatment getMissingPredictionTreatment() {
        if (missingPredictionTreatment == null) {
            return Segmentation.MissingPredictionTreatment.CONTINUE;
        } else {
            return missingPredictionTreatment;
        }
    }

    public Segmentation setMissingPredictionTreatment(
        @org.jpmml.model.annotations.Property("missingPredictionTreatment")
        Segmentation.MissingPredictionTreatment missingPredictionTreatment) {
        this.missingPredictionTreatment = missingPredictionTreatment;
        return this;
    }

    public Double getMissingThreshold() {
        if (missingThreshold == null) {
            return DEFAULT_MISSING_THRESHOLD;
        } else {
            return missingThreshold;
        }
    }

    public Segmentation setMissingThreshold(
        @org.jpmml.model.annotations.Property("missingThreshold")
        Double missingThreshold) {
        this.missingThreshold = missingThreshold;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public Segmentation setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public List<Segment> getSegments() {
        if (segments == null) {
            segments = new ArrayList<Segment>();
        }
        return this.segments;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Segmentation addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSegments() {
        return ((this.segments!= null)&&(this.segments.size()> 0));
    }

    public Segmentation addSegments(Segment... segments) {
        getSegments().addAll(Arrays.asList(segments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSegments()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSegments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    @org.jpmml.model.annotations.Extension
    public enum MissingPredictionTreatment
        implements StringValue<Segmentation.MissingPredictionTreatment>
    {

        @XmlEnumValue("returnMissing")
        @JsonProperty("returnMissing")
        RETURN_MISSING("returnMissing"),
        @XmlEnumValue("skipSegment")
        @JsonProperty("skipSegment")
        SKIP_SEGMENT("skipSegment"),
        @XmlEnumValue("continue")
        @JsonProperty("continue")
        CONTINUE("continue");
        private final String value;

        MissingPredictionTreatment(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Segmentation.MissingPredictionTreatment fromValue(String v) {
            for (Segmentation.MissingPredictionTreatment c: Segmentation.MissingPredictionTreatment.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum MultipleModelMethod
        implements StringValue<Segmentation.MultipleModelMethod>
    {

        @XmlEnumValue("majorityVote")
        @JsonProperty("majorityVote")
        MAJORITY_VOTE("majorityVote"),
        @XmlEnumValue("weightedMajorityVote")
        @JsonProperty("weightedMajorityVote")
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote"),
        @XmlEnumValue("average")
        @JsonProperty("average")
        AVERAGE("average"),
        @XmlEnumValue("weightedAverage")
        @JsonProperty("weightedAverage")
        WEIGHTED_AVERAGE("weightedAverage"),
        @XmlEnumValue("median")
        @JsonProperty("median")
        MEDIAN("median"),
        @XmlEnumValue("x-weightedMedian")
        @org.jpmml.model.annotations.Extension
        @JsonProperty("x-weightedMedian")
        WEIGHTED_MEDIAN("x-weightedMedian"),
        @XmlEnumValue("max")
        @JsonProperty("max")
        MAX("max"),
        @XmlEnumValue("sum")
        @JsonProperty("sum")
        SUM("sum"),
        @XmlEnumValue("x-weightedSum")
        @org.jpmml.model.annotations.Extension
        @JsonProperty("x-weightedSum")
        WEIGHTED_SUM("x-weightedSum"),
        @XmlEnumValue("selectFirst")
        @JsonProperty("selectFirst")
        SELECT_FIRST("selectFirst"),
        @XmlEnumValue("selectAll")
        @JsonProperty("selectAll")
        SELECT_ALL("selectAll"),
        @XmlEnumValue("modelChain")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        @JsonProperty("modelChain")
        MODEL_CHAIN("modelChain");
        private final String value;

        MultipleModelMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Segmentation.MultipleModelMethod fromValue(String v) {
            for (Segmentation.MultipleModelMethod c: Segmentation.MultipleModelMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
