
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValueCounts"
})
@XmlRootElement(name = "PairCounts", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "value",
    "extensions",
    "targetValueCounts"
})
public class PairCounts
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PairCounts>
{

    @XmlAttribute(name = "value", required = true)
    @JsonProperty("value")
    private String value;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValueCounts", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("TargetValueCounts")
    private TargetValueCounts targetValueCounts;
    private final static long serialVersionUID = 67305484L;

    public PairCounts() {
    }

    public PairCounts(
        @org.jpmml.model.annotations.Property("value")
        String value,
        @org.jpmml.model.annotations.Property("targetValueCounts")
        TargetValueCounts targetValueCounts) {
        this.value = value;
        this.targetValueCounts = targetValueCounts;
    }

    public String getValue() {
        return value;
    }

    public PairCounts setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public TargetValueCounts getTargetValueCounts() {
        return targetValueCounts;
    }

    public PairCounts setTargetValueCounts(
        @org.jpmml.model.annotations.Property("targetValueCounts")
        TargetValueCounts targetValueCounts) {
        this.targetValueCounts = targetValueCounts;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public PairCounts addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValueCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
