
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "value",
    "recordCount",
    "confidence",
    "probability",
    "extensions"
})
public class ScoreDistribution
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ScoreDistribution>
{

    @XmlAttribute(name = "value", required = true)
    @JsonProperty("value")
    private String value;
    @XmlAttribute(name = "recordCount", required = true)
    @JsonProperty("recordCount")
    private double recordCount;
    @XmlAttribute(name = "confidence")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("confidence")
    private Double confidence;
    @XmlAttribute(name = "probability")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("probability")
    private Double probability;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305484L;

    public ScoreDistribution() {
    }

    public ScoreDistribution(
        @org.jpmml.model.annotations.Property("value")
        String value,
        @org.jpmml.model.annotations.Property("recordCount")
        double recordCount) {
        this.value = value;
        this.recordCount = recordCount;
    }

    public String getValue() {
        return value;
    }

    public ScoreDistribution setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public double getRecordCount() {
        return recordCount;
    }

    public ScoreDistribution setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        double recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Double getConfidence() {
        return confidence;
    }

    public ScoreDistribution setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        Double confidence) {
        this.confidence = confidence;
        return this;
    }

    public Double getProbability() {
        return probability;
    }

    public ScoreDistribution setProbability(
        @org.jpmml.model.annotations.Property("probability")
        Double probability) {
        this.probability = probability;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ScoreDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
