
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Interval", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "closure",
    "leftMargin",
    "rightMargin",
    "extensions"
})
public class Interval
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Interval>
{

    @XmlAttribute(name = "closure", required = true)
    @JsonProperty("closure")
    private Interval.Closure closure;
    @XmlAttribute(name = "leftMargin")
    @JsonProperty("leftMargin")
    private Double leftMargin;
    @XmlAttribute(name = "rightMargin")
    @JsonProperty("rightMargin")
    private Double rightMargin;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305484L;

    public Interval() {
    }

    public Interval(
        @org.jpmml.model.annotations.Property("closure")
        Interval.Closure closure) {
        this.closure = closure;
    }

    public Interval.Closure getClosure() {
        return closure;
    }

    public Interval setClosure(
        @org.jpmml.model.annotations.Property("closure")
        Interval.Closure closure) {
        this.closure = closure;
        return this;
    }

    public Double getLeftMargin() {
        return leftMargin;
    }

    public Interval setLeftMargin(
        @org.jpmml.model.annotations.Property("leftMargin")
        Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    public Double getRightMargin() {
        return rightMargin;
    }

    public Interval setRightMargin(
        @org.jpmml.model.annotations.Property("rightMargin")
        Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Interval addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Closure
        implements StringValue<Interval.Closure>
    {

        @XmlEnumValue("openClosed")
        @JsonProperty("openClosed")
        OPEN_CLOSED("openClosed"),
        @XmlEnumValue("openOpen")
        @JsonProperty("openOpen")
        OPEN_OPEN("openOpen"),
        @XmlEnumValue("closedOpen")
        @JsonProperty("closedOpen")
        CLOSED_OPEN("closedOpen"),
        @XmlEnumValue("closedClosed")
        @JsonProperty("closedClosed")
        CLOSED_CLOSED("closedClosed");
        private final String value;

        Closure(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Interval.Closure fromValue(String v) {
            for (Interval.Closure c: Interval.Closure.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
