
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;

@XmlType(name = "MINING-FUNCTION", namespace = "http://www.dmg.org/PMML-4_3")
@XmlEnum
public enum MiningFunction
    implements StringValue<MiningFunction>
{

    @XmlEnumValue("associationRules")
    @JsonProperty("associationRules")
    ASSOCIATION_RULES("associationRules"),
    @XmlEnumValue("sequences")
    @JsonProperty("sequences")
    SEQUENCES("sequences"),
    @XmlEnumValue("classification")
    @JsonProperty("classification")
    CLASSIFICATION("classification"),
    @XmlEnumValue("regression")
    @JsonProperty("regression")
    REGRESSION("regression"),
    @XmlEnumValue("clustering")
    @JsonProperty("clustering")
    CLUSTERING("clustering"),
    @XmlEnumValue("timeSeries")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("timeSeries")
    TIME_SERIES("timeSeries"),
    @XmlEnumValue("mixed")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("mixed")
    MIXED("mixed");
    private final String value;

    MiningFunction(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MiningFunction fromValue(String v) {
        for (MiningFunction c: MiningFunction.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
