
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "childParents"
})
@XmlRootElement(name = "Taxonomy", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "name",
    "extensions",
    "childParents"
})
public class Taxonomy
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Taxonomy>
{

    @XmlAttribute(name = "name", required = true)
    @JsonProperty("name")
    private String name;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ChildParent", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("ChildParent")
    private List<ChildParent> childParents;
    private final static long serialVersionUID = 67305484L;

    public Taxonomy() {
    }

    public Taxonomy(
        @org.jpmml.model.annotations.Property("name")
        String name,
        @org.jpmml.model.annotations.Property("childParents")
        List<ChildParent> childParents) {
        this.name = name;
        this.childParents = childParents;
    }

    public String getName() {
        return name;
    }

    public Taxonomy setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<ChildParent> getChildParents() {
        if (childParents == null) {
            childParents = new ArrayList<ChildParent>();
        }
        return this.childParents;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Taxonomy addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasChildParents() {
        return ((this.childParents!= null)&&(this.childParents.size()> 0));
    }

    public Taxonomy addChildParents(ChildParent... childParents) {
        getChildParents().addAll(Arrays.asList(childParents));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasChildParents()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getChildParents());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
