
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "ValueProbability", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "value",
    "probability",
    "extensions"
})
public class ValueProbability
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ValueProbability>
{

    @XmlAttribute(name = "value", required = true)
    @JsonProperty("value")
    private String value;
    @XmlAttribute(name = "probability", required = true)
    @JsonProperty("probability")
    private double probability;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305484L;

    public ValueProbability() {
    }

    public ValueProbability(
        @org.jpmml.model.annotations.Property("value")
        String value,
        @org.jpmml.model.annotations.Property("probability")
        double probability) {
        this.value = value;
        this.probability = probability;
    }

    public String getValue() {
        return value;
    }

    public ValueProbability setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public double getProbability() {
        return probability;
    }

    public ValueProbability setProbability(
        @org.jpmml.model.annotations.Property("probability")
        double probability) {
        this.probability = probability;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ValueProbability addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
