
package org.dmg.pmml.rule_set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasPredicate;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "scoreDistributions"
})
@XmlRootElement(name = "SimpleRule", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "id",
    "score",
    "recordCount",
    "nbCorrect",
    "confidence",
    "weight",
    "extensions",
    "predicate",
    "scoreDistributions"
})
public class SimpleRule
    extends Rule
    implements HasExtensions<SimpleRule> , HasPredicate<SimpleRule>
{

    @XmlAttribute(name = "id")
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "score", required = true)
    @JsonProperty("score")
    private String score;
    @XmlAttribute(name = "recordCount")
    @JsonProperty("recordCount")
    private Double recordCount;
    @XmlAttribute(name = "nbCorrect")
    @JsonProperty("nbCorrect")
    private Double nbCorrect;
    @XmlAttribute(name = "confidence")
    @JsonProperty("confidence")
    private Double confidence;
    @XmlAttribute(name = "weight")
    @JsonProperty("weight")
    private Double weight;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.False.class)
    })
    @JsonProperty("Predicate")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimplePredicate", value = org.dmg.pmml.SimplePredicate.class),
        @JsonSubTypes.Type(name = "CompoundPredicate", value = org.dmg.pmml.CompoundPredicate.class),
        @JsonSubTypes.Type(name = "SimpleSetPredicate", value = org.dmg.pmml.SimpleSetPredicate.class),
        @JsonSubTypes.Type(name = "True", value = org.dmg.pmml.True.class),
        @JsonSubTypes.Type(name = "False", value = org.dmg.pmml.False.class)
    })
    private Predicate predicate;
    @XmlElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ScoreDistribution")
    private List<ScoreDistribution> scoreDistributions;
    private final static Double DEFAULT_CONFIDENCE = 1.0D;
    private final static Double DEFAULT_WEIGHT = 1.0D;
    private final static long serialVersionUID = 67305484L;

    public SimpleRule() {
    }

    public SimpleRule(
        @org.jpmml.model.annotations.Property("score")
        String score) {
        this.score = score;
    }

    public String getId() {
        return id;
    }

    public SimpleRule setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public String getScore() {
        return score;
    }

    public SimpleRule setScore(
        @org.jpmml.model.annotations.Property("score")
        String score) {
        this.score = score;
        return this;
    }

    public Double getRecordCount() {
        return recordCount;
    }

    public SimpleRule setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Double recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Double getNbCorrect() {
        return nbCorrect;
    }

    public SimpleRule setNbCorrect(
        @org.jpmml.model.annotations.Property("nbCorrect")
        Double nbCorrect) {
        this.nbCorrect = nbCorrect;
        return this;
    }

    public Double getConfidence() {
        if (confidence == null) {
            return DEFAULT_CONFIDENCE;
        } else {
            return confidence;
        }
    }

    public SimpleRule setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        Double confidence) {
        this.confidence = confidence;
        return this;
    }

    public Double getWeight() {
        if (weight == null) {
            return DEFAULT_WEIGHT;
        } else {
            return weight;
        }
    }

    public SimpleRule setWeight(
        @org.jpmml.model.annotations.Property("weight")
        Double weight) {
        this.weight = weight;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Predicate getPredicate() {
        return predicate;
    }

    public SimpleRule setPredicate(
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public List<ScoreDistribution> getScoreDistributions() {
        if (scoreDistributions == null) {
            scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SimpleRule addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasScoreDistributions() {
        return ((this.scoreDistributions!= null)&&(this.scoreDistributions.size()> 0));
    }

    public SimpleRule addScoreDistributions(ScoreDistribution... scoreDistributions) {
        getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getPredicate());
            }
            if ((status == VisitorAction.CONTINUE)&&hasScoreDistributions()) {
                status = PMMLObject.traverse(visitor, getScoreDistributions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
