
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "discretizeBins"
})
@XmlRootElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "field",
    "mapMissingTo",
    "defaultValue",
    "dataType",
    "extensions",
    "discretizeBins"
})
public class Discretize
    extends Expression
    implements HasDataType<Discretize> , HasDefaultValue<Discretize> , HasExtensions<Discretize> , HasFieldReference<Discretize> , HasMapMissingTo<Discretize, String>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "mapMissingTo")
    @JsonProperty("mapMissingTo")
    private String mapMissingTo;
    @XmlAttribute(name = "defaultValue")
    @JsonProperty("defaultValue")
    private String defaultValue;
    @XmlAttribute(name = "dataType")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("dataType")
    private DataType dataType;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "DiscretizeBin", namespace = "http://www.dmg.org/PMML-4_3")
    @Optional((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("DiscretizeBin")
    private List<DiscretizeBin> discretizeBins;
    private final static long serialVersionUID = 67305484L;

    public Discretize() {
    }

    public Discretize(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    public FieldName getField() {
        return field;
    }

    public Discretize setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public String getMapMissingTo() {
        return mapMissingTo;
    }

    public Discretize setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        String mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public Discretize setDefaultValue(
        @org.jpmml.model.annotations.Property("defaultValue")
        String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DataType getDataType() {
        return dataType;
    }

    public Discretize setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<DiscretizeBin> getDiscretizeBins() {
        if (discretizeBins == null) {
            discretizeBins = new ArrayList<DiscretizeBin>();
        }
        return this.discretizeBins;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Discretize addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDiscretizeBins() {
        return ((this.discretizeBins!= null)&&(this.discretizeBins.size()> 0));
    }

    public Discretize addDiscretizeBins(DiscretizeBin... discretizeBins) {
        getDiscretizeBins().addAll(Arrays.asList(discretizeBins));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDiscretizeBins()) {
                status = PMMLObject.traverse(visitor, getDiscretizeBins());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
