
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "modelLiftGraph",
    "optimumLiftGraph",
    "randomLiftGraph"
})
@XmlRootElement(name = "LiftData", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "targetFieldValue",
    "targetFieldDisplayValue",
    "rankingQuality",
    "extensions",
    "modelLiftGraph",
    "optimumLiftGraph",
    "randomLiftGraph"
})
public class LiftData
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<LiftData>
{

    @XmlAttribute(name = "targetFieldValue")
    @JsonProperty("targetFieldValue")
    private String targetFieldValue;
    @XmlAttribute(name = "targetFieldDisplayValue")
    @JsonProperty("targetFieldDisplayValue")
    private String targetFieldDisplayValue;
    @XmlAttribute(name = "rankingQuality")
    @JsonProperty("rankingQuality")
    private Double rankingQuality;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ModelLiftGraph", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("ModelLiftGraph")
    private ModelLiftGraph modelLiftGraph;
    @XmlElement(name = "OptimumLiftGraph", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("OptimumLiftGraph")
    private OptimumLiftGraph optimumLiftGraph;
    @XmlElement(name = "RandomLiftGraph", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("RandomLiftGraph")
    private RandomLiftGraph randomLiftGraph;
    private final static long serialVersionUID = 67305485L;

    public LiftData() {
    }

    public LiftData(
        @org.jpmml.model.annotations.Property("modelLiftGraph")
        ModelLiftGraph modelLiftGraph) {
        this.modelLiftGraph = modelLiftGraph;
    }

    public String getTargetFieldValue() {
        return targetFieldValue;
    }

    public LiftData setTargetFieldValue(
        @org.jpmml.model.annotations.Property("targetFieldValue")
        String targetFieldValue) {
        this.targetFieldValue = targetFieldValue;
        return this;
    }

    public String getTargetFieldDisplayValue() {
        return targetFieldDisplayValue;
    }

    public LiftData setTargetFieldDisplayValue(
        @org.jpmml.model.annotations.Property("targetFieldDisplayValue")
        String targetFieldDisplayValue) {
        this.targetFieldDisplayValue = targetFieldDisplayValue;
        return this;
    }

    public Double getRankingQuality() {
        return rankingQuality;
    }

    public LiftData setRankingQuality(
        @org.jpmml.model.annotations.Property("rankingQuality")
        Double rankingQuality) {
        this.rankingQuality = rankingQuality;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public LiftData addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ModelLiftGraph getModelLiftGraph() {
        return modelLiftGraph;
    }

    public LiftData setModelLiftGraph(
        @org.jpmml.model.annotations.Property("modelLiftGraph")
        ModelLiftGraph modelLiftGraph) {
        this.modelLiftGraph = modelLiftGraph;
        return this;
    }

    public OptimumLiftGraph getOptimumLiftGraph() {
        return optimumLiftGraph;
    }

    public LiftData setOptimumLiftGraph(
        @org.jpmml.model.annotations.Property("optimumLiftGraph")
        OptimumLiftGraph optimumLiftGraph) {
        this.optimumLiftGraph = optimumLiftGraph;
        return this;
    }

    public RandomLiftGraph getRandomLiftGraph() {
        return randomLiftGraph;
    }

    public LiftData setRandomLiftGraph(
        @org.jpmml.model.annotations.Property("randomLiftGraph")
        RandomLiftGraph randomLiftGraph) {
        this.randomLiftGraph = randomLiftGraph;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getModelLiftGraph(), getOptimumLiftGraph(), getRandomLiftGraph());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
