
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "value"
})
@XmlRootElement(name = "MatCell", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "row",
    "col",
    "value"
})
public class MatCell
    extends PMMLObject
{

    @XmlAttribute(name = "row", required = true)
    @JsonProperty("row")
    private int row;
    @XmlAttribute(name = "col", required = true)
    @JsonProperty("col")
    private int col;
    @XmlValue
    @JsonProperty("value")
    @XmlValueExtension
    private String value;
    private final static long serialVersionUID = 67305485L;

    public MatCell() {
    }

    public MatCell(
        @org.jpmml.model.annotations.Property("row")
        int row,
        @org.jpmml.model.annotations.Property("col")
        int col,
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.row = row;
        this.col = col;
        this.value = value;
    }

    public int getRow() {
        return row;
    }

    public MatCell setRow(
        @org.jpmml.model.annotations.Property("row")
        int row) {
        this.row = row;
        return this;
    }

    public int getCol() {
        return col;
    }

    public MatCell setCol(
        @org.jpmml.model.annotations.Property("col")
        int col) {
        this.col = col;
        return this;
    }

    public String getValue() {
        return value;
    }

    public MatCell setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
