
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "mean",
    "variance"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "extensions",
    "mean",
    "variance"
})
public class LognormalDistribution
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<LognormalDistribution>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Mean", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Mean")
    private Mean mean;
    @XmlElement(name = "Variance", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Variance")
    private Variance variance;
    private final static long serialVersionUID = 67305485L;

    public LognormalDistribution() {
    }

    public LognormalDistribution(
        @org.jpmml.model.annotations.Property("mean")
        Mean mean,
        @org.jpmml.model.annotations.Property("variance")
        Variance variance) {
        this.mean = mean;
        this.variance = variance;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public LognormalDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Mean getMean() {
        return mean;
    }

    public LognormalDistribution setMean(
        @org.jpmml.model.annotations.Property("mean")
        Mean mean) {
        this.mean = mean;
        return this;
    }

    public Variance getVariance() {
        return variance;
    }

    public LognormalDistribution setVariance(
        @org.jpmml.model.annotations.Property("variance")
        Variance variance) {
        this.variance = variance;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMean(), getVariance());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
