
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "baselineStrata",
    "baselineCells"
})
@XmlRootElement(name = "BaseCumHazardTables", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "maxTime",
    "extensions",
    "baselineStrata",
    "baselineCells"
})
public class BaseCumHazardTables
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BaseCumHazardTables>
{

    @XmlAttribute(name = "maxTime")
    @JsonProperty("maxTime")
    private Double maxTime;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "BaselineStratum", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("BaselineStratum")
    private List<BaselineStratum> baselineStrata;
    @XmlElement(name = "BaselineCell", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("BaselineCell")
    private List<BaselineCell> baselineCells;
    private final static long serialVersionUID = 67305485L;

    public Double getMaxTime() {
        return maxTime;
    }

    public BaseCumHazardTables setMaxTime(
        @Property("maxTime")
        Double maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BaseCumHazardTables addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBaselineStrata() {
        return ((this.baselineStrata!= null)&&(this.baselineStrata.size()> 0));
    }

    public List<BaselineStratum> getBaselineStrata() {
        if (baselineStrata == null) {
            baselineStrata = new ArrayList<BaselineStratum>();
        }
        return this.baselineStrata;
    }

    public BaseCumHazardTables addBaselineStrata(BaselineStratum... baselineStrata) {
        getBaselineStrata().addAll(Arrays.asList(baselineStrata));
        return this;
    }

    public boolean hasBaselineCells() {
        return ((this.baselineCells!= null)&&(this.baselineCells.size()> 0));
    }

    public List<BaselineCell> getBaselineCells() {
        if (baselineCells == null) {
            baselineCells = new ArrayList<BaselineCell>();
        }
        return this.baselineCells;
    }

    public BaseCumHazardTables addBaselineCells(BaselineCell... baselineCells) {
        getBaselineCells().addAll(Arrays.asList(baselineCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBaselineStrata()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaselineStrata());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBaselineCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaselineCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
