
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "PCell", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "targetCategory",
    "parameterName",
    "beta",
    "df",
    "extensions"
})
public class PCell
    extends ParameterCell
    implements HasExtensions<PCell>
{

    @XmlAttribute(name = "targetCategory")
    @JsonProperty("targetCategory")
    private String targetCategory;
    @XmlAttribute(name = "parameterName", required = true)
    @JsonProperty("parameterName")
    private String parameterName;
    @XmlAttribute(name = "beta", required = true)
    @JsonProperty("beta")
    private double beta;
    @XmlAttribute(name = "df")
    @JsonProperty("df")
    private Integer df;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305485L;

    public PCell() {
    }

    public PCell(
        @org.jpmml.model.annotations.Property("parameterName")
        String parameterName,
        @org.jpmml.model.annotations.Property("beta")
        double beta) {
        this.parameterName = parameterName;
        this.beta = beta;
    }

    public String getTargetCategory() {
        return targetCategory;
    }

    public PCell setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        String targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    public String getParameterName() {
        return parameterName;
    }

    public PCell setParameterName(
        @org.jpmml.model.annotations.Property("parameterName")
        String parameterName) {
        this.parameterName = parameterName;
        return this;
    }

    public double getBeta() {
        return beta;
    }

    public PCell setBeta(
        @org.jpmml.model.annotations.Property("beta")
        double beta) {
        this.beta = beta;
        return this;
    }

    public Integer getDf() {
        return df;
    }

    public PCell setDf(
        @org.jpmml.model.annotations.Property("df")
        Integer df) {
        this.df = df;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PCell addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
