
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "intervals",
    "arrays"
})
@XmlRootElement(name = "ContStats", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "totalValuesSum",
    "totalSquaresSum",
    "extensions",
    "intervals",
    "arrays"
})
public class ContStats
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ContStats>
{

    @XmlAttribute(name = "totalValuesSum")
    @JsonProperty("totalValuesSum")
    private Double totalValuesSum;
    @XmlAttribute(name = "totalSquaresSum")
    @JsonProperty("totalSquaresSum")
    private Double totalSquaresSum;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Interval", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Interval")
    private List<Interval> intervals;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Array")
    private List<Array> arrays;
    private final static long serialVersionUID = 67305485L;

    public Double getTotalValuesSum() {
        return totalValuesSum;
    }

    public ContStats setTotalValuesSum(
        @Property("totalValuesSum")
        Double totalValuesSum) {
        this.totalValuesSum = totalValuesSum;
        return this;
    }

    public Double getTotalSquaresSum() {
        return totalSquaresSum;
    }

    public ContStats setTotalSquaresSum(
        @Property("totalSquaresSum")
        Double totalSquaresSum) {
        this.totalSquaresSum = totalSquaresSum;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ContStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasIntervals() {
        return ((this.intervals!= null)&&(this.intervals.size()> 0));
    }

    public List<Interval> getIntervals() {
        if (intervals == null) {
            intervals = new ArrayList<Interval>();
        }
        return this.intervals;
    }

    public ContStats addIntervals(Interval... intervals) {
        getIntervals().addAll(Arrays.asList(intervals));
        return this;
    }

    public boolean hasArrays() {
        return ((this.arrays!= null)&&(this.arrays.size()> 0));
    }

    public List<Array> getArrays() {
        if (arrays == null) {
            arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    public ContStats addArrays(Array... arrays) {
        getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasIntervals()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getIntervals());
            }
            if ((status == VisitorAction.CONTINUE)&&hasArrays()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArrays());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
