
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "arrays",
    "matCells"
})
@XmlRootElement(name = "Matrix", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "kind",
    "nbRows",
    "nbCols",
    "diagDefault",
    "offDiagDefault",
    "arrays",
    "matCells"
})
public class Matrix
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "kind")
    @JsonProperty("kind")
    private Matrix.Kind kind;
    @XmlAttribute(name = "nbRows")
    @JsonProperty("nbRows")
    private Integer nbRows;
    @XmlAttribute(name = "nbCols")
    @JsonProperty("nbCols")
    private Integer nbCols;
    @XmlAttribute(name = "diagDefault")
    @JsonProperty("diagDefault")
    private Double diagDefault;
    @XmlAttribute(name = "offDiagDefault")
    @JsonProperty("offDiagDefault")
    private Double offDiagDefault;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Array")
    private List<Array> arrays;
    @XmlElement(name = "MatCell", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("MatCell")
    private List<MatCell> matCells;
    private final static long serialVersionUID = 67305485L;

    public Matrix.Kind getKind() {
        if (kind == null) {
            return Matrix.Kind.ANY;
        } else {
            return kind;
        }
    }

    public Matrix setKind(
        @Property("kind")
        Matrix.Kind kind) {
        this.kind = kind;
        return this;
    }

    public Integer getNbRows() {
        return nbRows;
    }

    public Matrix setNbRows(
        @Property("nbRows")
        Integer nbRows) {
        this.nbRows = nbRows;
        return this;
    }

    public Integer getNbCols() {
        return nbCols;
    }

    public Matrix setNbCols(
        @Property("nbCols")
        Integer nbCols) {
        this.nbCols = nbCols;
        return this;
    }

    public Double getDiagDefault() {
        return diagDefault;
    }

    public Matrix setDiagDefault(
        @Property("diagDefault")
        Double diagDefault) {
        this.diagDefault = diagDefault;
        return this;
    }

    public Double getOffDiagDefault() {
        return offDiagDefault;
    }

    public Matrix setOffDiagDefault(
        @Property("offDiagDefault")
        Double offDiagDefault) {
        this.offDiagDefault = offDiagDefault;
        return this;
    }

    public boolean hasArrays() {
        return ((this.arrays!= null)&&(this.arrays.size()> 0));
    }

    public List<Array> getArrays() {
        if (arrays == null) {
            arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    public Matrix addArrays(Array... arrays) {
        getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    public boolean hasMatCells() {
        return ((this.matCells!= null)&&(this.matCells.size()> 0));
    }

    public List<MatCell> getMatCells() {
        if (matCells == null) {
            matCells = new ArrayList<MatCell>();
        }
        return this.matCells;
    }

    public Matrix addMatCells(MatCell... matCells) {
        getMatCells().addAll(Arrays.asList(matCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasArrays()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArrays());
            }
            if ((status == VisitorAction.CONTINUE)&&hasMatCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMatCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Kind
        implements StringValue<Matrix.Kind>
    {

        @XmlEnumValue("diagonal")
        @JsonProperty("diagonal")
        DIAGONAL("diagonal"),
        @XmlEnumValue("symmetric")
        @JsonProperty("symmetric")
        SYMMETRIC("symmetric"),
        @XmlEnumValue("any")
        @JsonProperty("any")
        ANY("any");
        private final String value;

        Kind(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Matrix.Kind fromValue(String v) {
            for (Matrix.Kind c: Matrix.Kind.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
