
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "header",
    "miningBuildTask",
    "dataDictionary",
    "transformationDictionary",
    "models",
    "extensions"
})
@XmlRootElement(name = "PMML", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "version",
    "baseVersion",
    "header",
    "miningBuildTask",
    "dataDictionary",
    "transformationDictionary",
    "models",
    "extensions"
})
public class PMML
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PMML>
{

    @XmlAttribute(name = "version", required = true)
    @JsonProperty("version")
    private String version;
    @XmlAttribute(name = "x-baseVersion")
    @org.jpmml.model.annotations.Extension
    @JsonProperty("x-baseVersion")
    private String baseVersion;
    @XmlElement(name = "Header", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Header")
    private Header header;
    @XmlElement(name = "MiningBuildTask", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("MiningBuildTask")
    private MiningBuildTask miningBuildTask;
    @XmlElement(name = "DataDictionary", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("DataDictionary")
    private DataDictionary dataDictionary;
    @XmlElement(name = "TransformationDictionary", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("TransformationDictionary")
    private TransformationDictionary transformationDictionary;
    @XmlElements({
        @XmlElement(name = "AssociationModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.association.AssociationModel.class),
        @XmlElement(name = "BayesianNetworkModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.bayesian_network.BayesianNetworkModel.class),
        @XmlElement(name = "BaselineModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.baseline.BaselineModel.class),
        @XmlElement(name = "ClusteringModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.clustering.ClusteringModel.class),
        @XmlElement(name = "GaussianProcessModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.gaussian_process.GaussianProcessModel.class),
        @XmlElement(name = "GeneralRegressionModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.general_regression.GeneralRegressionModel.class),
        @XmlElement(name = "MiningModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.mining.MiningModel.class),
        @XmlElement(name = "NaiveBayesModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.naive_bayes.NaiveBayesModel.class),
        @XmlElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.nearest_neighbor.NearestNeighborModel.class),
        @XmlElement(name = "NeuralNetwork", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.neural_network.NeuralNetwork.class),
        @XmlElement(name = "RegressionModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.regression.RegressionModel.class),
        @XmlElement(name = "RuleSetModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.rule_set.RuleSetModel.class),
        @XmlElement(name = "SequenceModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.sequence.SequenceModel.class),
        @XmlElement(name = "Scorecard", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.scorecard.Scorecard.class),
        @XmlElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.support_vector_machine.SupportVectorMachineModel.class),
        @XmlElement(name = "TextModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.text.TextModel.class),
        @XmlElement(name = "TimeSeriesModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.time_series.TimeSeriesModel.class),
        @XmlElement(name = "TreeModel", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.tree.TreeModel.class)
    })
    @JsonProperty("Model")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "AssociationModel", value = org.dmg.pmml.association.AssociationModel.class),
        @JsonSubTypes.Type(name = "BayesianNetworkModel", value = org.dmg.pmml.bayesian_network.BayesianNetworkModel.class),
        @JsonSubTypes.Type(name = "BaselineModel", value = org.dmg.pmml.baseline.BaselineModel.class),
        @JsonSubTypes.Type(name = "ClusteringModel", value = org.dmg.pmml.clustering.ClusteringModel.class),
        @JsonSubTypes.Type(name = "GaussianProcessModel", value = org.dmg.pmml.gaussian_process.GaussianProcessModel.class),
        @JsonSubTypes.Type(name = "GeneralRegressionModel", value = org.dmg.pmml.general_regression.GeneralRegressionModel.class),
        @JsonSubTypes.Type(name = "MiningModel", value = org.dmg.pmml.mining.MiningModel.class),
        @JsonSubTypes.Type(name = "NaiveBayesModel", value = org.dmg.pmml.naive_bayes.NaiveBayesModel.class),
        @JsonSubTypes.Type(name = "NearestNeighborModel", value = org.dmg.pmml.nearest_neighbor.NearestNeighborModel.class),
        @JsonSubTypes.Type(name = "NeuralNetwork", value = org.dmg.pmml.neural_network.NeuralNetwork.class),
        @JsonSubTypes.Type(name = "RegressionModel", value = org.dmg.pmml.regression.RegressionModel.class),
        @JsonSubTypes.Type(name = "RuleSetModel", value = org.dmg.pmml.rule_set.RuleSetModel.class),
        @JsonSubTypes.Type(name = "SequenceModel", value = org.dmg.pmml.sequence.SequenceModel.class),
        @JsonSubTypes.Type(name = "Scorecard", value = org.dmg.pmml.scorecard.Scorecard.class),
        @JsonSubTypes.Type(name = "SupportVectorMachineModel", value = org.dmg.pmml.support_vector_machine.SupportVectorMachineModel.class),
        @JsonSubTypes.Type(name = "TextModel", value = org.dmg.pmml.text.TextModel.class),
        @JsonSubTypes.Type(name = "TimeSeriesModel", value = org.dmg.pmml.time_series.TimeSeriesModel.class),
        @JsonSubTypes.Type(name = "TreeModel", value = org.dmg.pmml.tree.TreeModel.class)
    })
    private List<Model> models;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<org.dmg.pmml.Extension> extensions;
    private final static long serialVersionUID = 67305485L;

    public PMML() {
    }

    public PMML(
        @org.jpmml.model.annotations.Property("version")
        String version,
        @org.jpmml.model.annotations.Property("header")
        Header header,
        @org.jpmml.model.annotations.Property("dataDictionary")
        DataDictionary dataDictionary) {
        this.version = version;
        this.header = header;
        this.dataDictionary = dataDictionary;
    }

    public String getVersion() {
        return version;
    }

    public PMML setVersion(
        @org.jpmml.model.annotations.Property("version")
        String version) {
        this.version = version;
        return this;
    }

    public String getBaseVersion() {
        return baseVersion;
    }

    public PMML setBaseVersion(
        @org.jpmml.model.annotations.Property("baseVersion")
        String baseVersion) {
        this.baseVersion = baseVersion;
        return this;
    }

    public Header getHeader() {
        return header;
    }

    public PMML setHeader(
        @org.jpmml.model.annotations.Property("header")
        Header header) {
        this.header = header;
        return this;
    }

    public MiningBuildTask getMiningBuildTask() {
        return miningBuildTask;
    }

    public PMML setMiningBuildTask(
        @org.jpmml.model.annotations.Property("miningBuildTask")
        MiningBuildTask miningBuildTask) {
        this.miningBuildTask = miningBuildTask;
        return this;
    }

    public DataDictionary getDataDictionary() {
        return dataDictionary;
    }

    public PMML setDataDictionary(
        @org.jpmml.model.annotations.Property("dataDictionary")
        DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
        return this;
    }

    public TransformationDictionary getTransformationDictionary() {
        return transformationDictionary;
    }

    public PMML setTransformationDictionary(
        @org.jpmml.model.annotations.Property("transformationDictionary")
        TransformationDictionary transformationDictionary) {
        this.transformationDictionary = transformationDictionary;
        return this;
    }

    public boolean hasModels() {
        return ((this.models!= null)&&(this.models.size()> 0));
    }

    public List<Model> getModels() {
        if (models == null) {
            models = new ArrayList<Model>();
        }
        return this.models;
    }

    public PMML addModels(Model... models) {
        getModels().addAll(Arrays.asList(models));
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    @Override
    public PMML addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getHeader(), getMiningBuildTask(), getDataDictionary(), getTransformationDictionary());
            }
            if ((status == VisitorAction.CONTINUE)&&hasModels()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getModels());
            }
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
