
package org.dmg.pmml.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "AssociationRule", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "antecedent",
    "consequent",
    "support",
    "confidence",
    "lift",
    "leverage",
    "affinity",
    "id",
    "extensions"
})
public class AssociationRule
    extends Entity
    implements HasExtensions<AssociationRule>
{

    @XmlAttribute(name = "antecedent", required = true)
    @JsonProperty("antecedent")
    private String antecedent;
    @XmlAttribute(name = "consequent", required = true)
    @JsonProperty("consequent")
    private String consequent;
    @XmlAttribute(name = "support", required = true)
    @JsonProperty("support")
    private double support;
    @XmlAttribute(name = "confidence", required = true)
    @JsonProperty("confidence")
    private double confidence;
    @XmlAttribute(name = "lift")
    @JsonProperty("lift")
    private Double lift;
    @XmlAttribute(name = "leverage")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("leverage")
    private Double leverage;
    @XmlAttribute(name = "affinity")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("affinity")
    private Double affinity;
    @XmlAttribute(name = "id")
    @JsonProperty("id")
    private String id;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305485L;

    public AssociationRule() {
    }

    public AssociationRule(
        @org.jpmml.model.annotations.Property("antecedent")
        String antecedent,
        @org.jpmml.model.annotations.Property("consequent")
        String consequent,
        @org.jpmml.model.annotations.Property("support")
        double support,
        @org.jpmml.model.annotations.Property("confidence")
        double confidence) {
        this.antecedent = antecedent;
        this.consequent = consequent;
        this.support = support;
        this.confidence = confidence;
    }

    public String getAntecedent() {
        return antecedent;
    }

    public AssociationRule setAntecedent(
        @org.jpmml.model.annotations.Property("antecedent")
        String antecedent) {
        this.antecedent = antecedent;
        return this;
    }

    public String getConsequent() {
        return consequent;
    }

    public AssociationRule setConsequent(
        @org.jpmml.model.annotations.Property("consequent")
        String consequent) {
        this.consequent = consequent;
        return this;
    }

    public double getSupport() {
        return support;
    }

    public AssociationRule setSupport(
        @org.jpmml.model.annotations.Property("support")
        double support) {
        this.support = support;
        return this;
    }

    public double getConfidence() {
        return confidence;
    }

    public AssociationRule setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        double confidence) {
        this.confidence = confidence;
        return this;
    }

    public Double getLift() {
        return lift;
    }

    public AssociationRule setLift(
        @org.jpmml.model.annotations.Property("lift")
        Double lift) {
        this.lift = lift;
        return this;
    }

    public Double getLeverage() {
        return leverage;
    }

    public AssociationRule setLeverage(
        @org.jpmml.model.annotations.Property("leverage")
        Double leverage) {
        this.leverage = leverage;
        return this;
    }

    public Double getAffinity() {
        return affinity;
    }

    public AssociationRule setAffinity(
        @org.jpmml.model.annotations.Property("affinity")
        Double affinity) {
        this.affinity = affinity;
        return this;
    }

    public String getId() {
        return id;
    }

    public AssociationRule setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AssociationRule addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
