
package org.dmg.pmml.rule_set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "ruleSelectionMethods",
    "scoreDistributions",
    "rules"
})
@XmlRootElement(name = "RuleSet", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "recordCount",
    "nbCorrect",
    "defaultScore",
    "defaultConfidence",
    "extensions",
    "ruleSelectionMethods",
    "scoreDistributions",
    "rules"
})
public class RuleSet
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<RuleSet>
{

    @XmlAttribute(name = "recordCount")
    @JsonProperty("recordCount")
    private Double recordCount;
    @XmlAttribute(name = "nbCorrect")
    @JsonProperty("nbCorrect")
    private Double nbCorrect;
    @XmlAttribute(name = "defaultScore")
    @JsonProperty("defaultScore")
    private String defaultScore;
    @XmlAttribute(name = "defaultConfidence")
    @JsonProperty("defaultConfidence")
    private Double defaultConfidence;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "RuleSelectionMethod", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("RuleSelectionMethod")
    private List<RuleSelectionMethod> ruleSelectionMethods;
    @XmlElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ScoreDistribution")
    private List<ScoreDistribution> scoreDistributions;
    @XmlElements({
        @XmlElement(name = "SimpleRule", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.rule_set.SimpleRule.class),
        @XmlElement(name = "CompoundRule", namespace = "http://www.dmg.org/PMML-4_3", type = org.dmg.pmml.rule_set.CompoundRule.class)
    })
    @JsonProperty("Rule")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimpleRule", value = org.dmg.pmml.rule_set.SimpleRule.class),
        @JsonSubTypes.Type(name = "CompoundRule", value = org.dmg.pmml.rule_set.CompoundRule.class)
    })
    private List<Rule> rules;
    private final static long serialVersionUID = 67305485L;

    public RuleSet() {
    }

    public RuleSet(
        @org.jpmml.model.annotations.Property("ruleSelectionMethods")
        List<RuleSelectionMethod> ruleSelectionMethods) {
        this.ruleSelectionMethods = ruleSelectionMethods;
    }

    public Double getRecordCount() {
        return recordCount;
    }

    public RuleSet setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Double recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Double getNbCorrect() {
        return nbCorrect;
    }

    public RuleSet setNbCorrect(
        @org.jpmml.model.annotations.Property("nbCorrect")
        Double nbCorrect) {
        this.nbCorrect = nbCorrect;
        return this;
    }

    public String getDefaultScore() {
        return defaultScore;
    }

    public RuleSet setDefaultScore(
        @org.jpmml.model.annotations.Property("defaultScore")
        String defaultScore) {
        this.defaultScore = defaultScore;
        return this;
    }

    public Double getDefaultConfidence() {
        return defaultConfidence;
    }

    public RuleSet setDefaultConfidence(
        @org.jpmml.model.annotations.Property("defaultConfidence")
        Double defaultConfidence) {
        this.defaultConfidence = defaultConfidence;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public RuleSet addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasRuleSelectionMethods() {
        return ((this.ruleSelectionMethods!= null)&&(this.ruleSelectionMethods.size()> 0));
    }

    public List<RuleSelectionMethod> getRuleSelectionMethods() {
        if (ruleSelectionMethods == null) {
            ruleSelectionMethods = new ArrayList<RuleSelectionMethod>();
        }
        return this.ruleSelectionMethods;
    }

    public RuleSet addRuleSelectionMethods(RuleSelectionMethod... ruleSelectionMethods) {
        getRuleSelectionMethods().addAll(Arrays.asList(ruleSelectionMethods));
        return this;
    }

    public boolean hasScoreDistributions() {
        return ((this.scoreDistributions!= null)&&(this.scoreDistributions.size()> 0));
    }

    public List<ScoreDistribution> getScoreDistributions() {
        if (scoreDistributions == null) {
            scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    public RuleSet addScoreDistributions(ScoreDistribution... scoreDistributions) {
        getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    public boolean hasRules() {
        return ((this.rules!= null)&&(this.rules.size()> 0));
    }

    public List<Rule> getRules() {
        if (rules == null) {
            rules = new ArrayList<Rule>();
        }
        return this.rules;
    }

    public RuleSet addRules(Rule... rules) {
        getRules().addAll(Arrays.asList(rules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRuleSelectionMethods()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getRuleSelectionMethods());
            }
            if ((status == VisitorAction.CONTINUE)&&hasScoreDistributions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getScoreDistributions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRules()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
