
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "ParameterField", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "name",
    "opType",
    "dataType"
})
public class ParameterField
    extends Field<ParameterField>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("name")
    private FieldName name;
    @XmlAttribute(name = "optype")
    @JsonProperty("optype")
    private OpType opType;
    @XmlAttribute(name = "dataType")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("dataType")
    private DataType dataType;
    private final static long serialVersionUID = 67305486L;

    public ParameterField() {
    }

    public ParameterField(
        @org.jpmml.model.annotations.Property("name")
        FieldName name) {
        this.name = name;
    }

    public FieldName getName() {
        return name;
    }

    public ParameterField setName(
        @org.jpmml.model.annotations.Property("name")
        FieldName name) {
        this.name = name;
        return this;
    }

    public OpType getOpType() {
        return opType;
    }

    public ParameterField setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    public DataType getDataType() {
        return dataType;
    }

    public ParameterField setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
