
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "triangularDistributionForBN",
    "normalDistributionForBN",
    "lognormalDistributionForBN",
    "uniformDistributionForBN"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "extensions",
    "triangularDistributionForBN",
    "normalDistributionForBN",
    "lognormalDistributionForBN",
    "uniformDistributionForBN"
})
public class ContinuousDistribution
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ContinuousDistribution>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "TriangularDistributionForBN", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("TriangularDistributionForBN")
    private TriangularDistribution triangularDistributionForBN;
    @XmlElement(name = "NormalDistributionForBN", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("NormalDistributionForBN")
    private NormalDistribution normalDistributionForBN;
    @XmlElement(name = "LognormalDistributionForBN", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("LognormalDistributionForBN")
    private LognormalDistribution lognormalDistributionForBN;
    @XmlElement(name = "UniformDistributionForBN", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("UniformDistributionForBN")
    private UniformDistribution uniformDistributionForBN;
    private final static long serialVersionUID = 67305486L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ContinuousDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public TriangularDistribution getTriangularDistributionForBN() {
        return triangularDistributionForBN;
    }

    public ContinuousDistribution setTriangularDistributionForBN(
        @Property("triangularDistributionForBN")
        TriangularDistribution triangularDistributionForBN) {
        this.triangularDistributionForBN = triangularDistributionForBN;
        return this;
    }

    public NormalDistribution getNormalDistributionForBN() {
        return normalDistributionForBN;
    }

    public ContinuousDistribution setNormalDistributionForBN(
        @Property("normalDistributionForBN")
        NormalDistribution normalDistributionForBN) {
        this.normalDistributionForBN = normalDistributionForBN;
        return this;
    }

    public LognormalDistribution getLognormalDistributionForBN() {
        return lognormalDistributionForBN;
    }

    public ContinuousDistribution setLognormalDistributionForBN(
        @Property("lognormalDistributionForBN")
        LognormalDistribution lognormalDistributionForBN) {
        this.lognormalDistributionForBN = lognormalDistributionForBN;
        return this;
    }

    public UniformDistribution getUniformDistributionForBN() {
        return uniformDistributionForBN;
    }

    public ContinuousDistribution setUniformDistributionForBN(
        @Property("uniformDistributionForBN")
        UniformDistribution uniformDistributionForBN) {
        this.uniformDistributionForBN = uniformDistributionForBN;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTriangularDistributionForBN(), getNormalDistributionForBN(), getLognormalDistributionForBN(), getUniformDistributionForBN());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
