
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "regressionTables",
    "modelVerification"
})
@XmlRootElement(name = "RegressionModel", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "modelType",
    "targetField",
    "normalizationMethod",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "regressionTables",
    "modelVerification"
})
public class RegressionModel
    extends Model
    implements HasExtensions<RegressionModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "modelType")
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_3_0))
    @JsonProperty("modelType")
    private RegressionModel.ModelType modelType;
    @XmlAttribute(name = "targetFieldName")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_3_0))
    @JsonProperty("targetFieldName")
    private FieldName targetField;
    @XmlAttribute(name = "normalizationMethod")
    @JsonProperty("normalizationMethod")
    private RegressionModel.NormalizationMethod normalizationMethod;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "RegressionTable", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("RegressionTable")
    private List<RegressionTable> regressionTables;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305486L;

    public RegressionModel() {
    }

    public RegressionModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("regressionTables")
        List<RegressionTable> regressionTables) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.regressionTables = regressionTables;
    }

    public String getModelName() {
        return modelName;
    }

    public RegressionModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public RegressionModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public RegressionModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public RegressionModel.ModelType getModelType() {
        return modelType;
    }

    public RegressionModel setModelType(
        @org.jpmml.model.annotations.Property("modelType")
        RegressionModel.ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    public FieldName getTargetField() {
        return targetField;
    }

    public RegressionModel setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    public RegressionModel.NormalizationMethod getNormalizationMethod() {
        if (normalizationMethod == null) {
            return RegressionModel.NormalizationMethod.NONE;
        } else {
            return normalizationMethod;
        }
    }

    public RegressionModel setNormalizationMethod(
        @org.jpmml.model.annotations.Property("normalizationMethod")
        RegressionModel.NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public RegressionModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public RegressionModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    @Override
    public RegressionModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public RegressionModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public RegressionModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public RegressionModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public RegressionModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public RegressionModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public RegressionModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasRegressionTables() {
        return ((this.regressionTables!= null)&&(this.regressionTables.size()> 0));
    }

    public List<RegressionTable> getRegressionTables() {
        if (regressionTables == null) {
            regressionTables = new ArrayList<RegressionTable>();
        }
        return this.regressionTables;
    }

    public RegressionModel addRegressionTables(RegressionTable... regressionTables) {
        getRegressionTables().addAll(Arrays.asList(regressionTables));
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public RegressionModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRegressionTables()) {
                status = PMMLObject.traverse(visitor, getRegressionTables());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum ModelType
        implements StringValue<RegressionModel.ModelType>
    {

        @XmlEnumValue("linearRegression")
        @JsonProperty("linearRegression")
        LINEAR_REGRESSION("linearRegression"),
        @XmlEnumValue("stepwisePolynomialRegression")
        @JsonProperty("stepwisePolynomialRegression")
        STEPWISE_POLYNOMIAL_REGRESSION("stepwisePolynomialRegression"),
        @XmlEnumValue("logisticRegression")
        @JsonProperty("logisticRegression")
        LOGISTIC_REGRESSION("logisticRegression");
        private final String value;

        ModelType(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static RegressionModel.ModelType fromValue(String v) {
            for (RegressionModel.ModelType c: RegressionModel.ModelType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum NormalizationMethod
        implements StringValue<RegressionModel.NormalizationMethod>
    {

        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @XmlEnumValue("simplemax")
        @JsonProperty("simplemax")
        SIMPLEMAX("simplemax"),
        @XmlEnumValue("softmax")
        @JsonProperty("softmax")
        SOFTMAX("softmax"),
        @XmlEnumValue("logit")
        @JsonProperty("logit")
        LOGIT("logit"),
        @XmlEnumValue("probit")
        @JsonProperty("probit")
        PROBIT("probit"),
        @XmlEnumValue("cloglog")
        @JsonProperty("cloglog")
        CLOGLOG("cloglog"),
        @XmlEnumValue("exp")
        @JsonProperty("exp")
        EXP("exp"),
        @XmlEnumValue("loglog")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
        @JsonProperty("loglog")
        LOGLOG("loglog"),
        @XmlEnumValue("cauchit")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
        @JsonProperty("cauchit")
        CAUCHIT("cauchit");
        private final String value;

        NormalizationMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static RegressionModel.NormalizationMethod fromValue(String v) {
            for (RegressionModel.NormalizationMethod c: RegressionModel.NormalizationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
