
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "fieldColumnPairs",
    "tableLocator",
    "inlineTable"
})
@JsonRootName("MapValues")
@JsonPropertyOrder({
    "mapMissingTo",
    "defaultValue",
    "outputColumn",
    "dataType",
    "extensions",
    "fieldColumnPairs",
    "tableLocator",
    "inlineTable"
})
public class MapValues
    extends Expression
    implements HasDataType<MapValues> , HasDefaultValue<MapValues, Object> , HasExtensions<MapValues> , HasMapMissingTo<MapValues, Object> , HasTable<MapValues>
{

    @XmlAttribute(name = "mapMissingTo")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("mapMissingTo")
    private Object mapMissingTo;
    @XmlAttribute(name = "defaultValue")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("defaultValue")
    private Object defaultValue;
    @XmlAttribute(name = "outputColumn", required = true)
    @JsonProperty("outputColumn")
    private String outputColumn;
    @XmlAttribute(name = "dataType")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("dataType")
    private DataType dataType;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "FieldColumnPair", namespace = "http://www.dmg.org/PMML-4_4")
    @Optional((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("FieldColumnPair")
    private List<FieldColumnPair> fieldColumnPairs;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TableLocator")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("InlineTable")
    private InlineTable inlineTable;
    private final static long serialVersionUID = 67371009L;

    public MapValues() {
    }

    @ValueConstructor
    public MapValues(
        @org.jpmml.model.annotations.Property("outputColumn")
        String outputColumn,
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator,
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.outputColumn = outputColumn;
        this.tableLocator = tableLocator;
        this.inlineTable = inlineTable;
    }

    @Override
    public Object getMapMissingTo() {
        return mapMissingTo;
    }

    @Override
    public MapValues setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        Object mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return defaultValue;
    }

    @Override
    public MapValues setDefaultValue(
        @org.jpmml.model.annotations.Property("defaultValue")
        Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String getOutputColumn() {
        return outputColumn;
    }

    public MapValues setOutputColumn(
        @org.jpmml.model.annotations.Property("outputColumn")
        String outputColumn) {
        this.outputColumn = outputColumn;
        return this;
    }

    @Override
    public DataType getDataType() {
        return dataType;
    }

    @Override
    public MapValues setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MapValues addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldColumnPairs() {
        return ((this.fieldColumnPairs!= null)&&(this.fieldColumnPairs.size()> 0));
    }

    public List<FieldColumnPair> getFieldColumnPairs() {
        if (fieldColumnPairs == null) {
            fieldColumnPairs = new ArrayList<FieldColumnPair>();
        }
        return this.fieldColumnPairs;
    }

    public MapValues addFieldColumnPairs(FieldColumnPair... fieldColumnPairs) {
        getFieldColumnPairs().addAll(Arrays.asList(fieldColumnPairs));
        return this;
    }

    @Override
    public TableLocator getTableLocator() {
        return tableLocator;
    }

    @Override
    public MapValues setTableLocator(
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    @Override
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    @Override
    public MapValues setInlineTable(
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldColumnPairs()) {
                status = PMMLObject.traverse(visitor, getFieldColumnPairs());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
