
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "ClusteringModelQuality", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("ClusteringModelQuality")
@JsonPropertyOrder({
    "dataName",
    "sse",
    "ssb",
    "extensions"
})
public class ClusteringModelQuality
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ClusteringModelQuality>
{

    @XmlAttribute(name = "dataName")
    @JsonProperty("dataName")
    private String dataName;
    @XmlAttribute(name = "SSE")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("SSE")
    private Number sse;
    @XmlAttribute(name = "SSB")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("SSB")
    private Number ssb;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371009L;

    public String getDataName() {
        return dataName;
    }

    public ClusteringModelQuality setDataName(
        @Property("dataName")
        String dataName) {
        this.dataName = dataName;
        return this;
    }

    public Number getSSE() {
        return sse;
    }

    public ClusteringModelQuality setSSE(
        @Property("sse")
        Number sse) {
        this.sse = sse;
        return this;
    }

    public Number getSSB() {
        return ssb;
    }

    public ClusteringModelQuality setSSB(
        @Property("ssb")
        Number ssb) {
        this.ssb = ssb;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ClusteringModelQuality addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
