
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "partitionFieldStats"
})
@JsonRootName("Partition")
@JsonPropertyOrder({
    "name",
    "size",
    "extensions",
    "partitionFieldStats"
})
public class Partition
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Partition>
{

    @XmlAttribute(name = "name", required = true)
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "size")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("size")
    private Number size;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "PartitionFieldStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("PartitionFieldStats")
    private List<PartitionFieldStats> partitionFieldStats;
    private final static long serialVersionUID = 67371009L;

    public Partition() {
    }

    @ValueConstructor
    public Partition(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public Partition setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public Number getSize() {
        return size;
    }

    public Partition setSize(
        @org.jpmml.model.annotations.Property("size")
        Number size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Partition addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPartitionFieldStats() {
        return ((this.partitionFieldStats!= null)&&(this.partitionFieldStats.size()> 0));
    }

    public List<PartitionFieldStats> getPartitionFieldStats() {
        if (partitionFieldStats == null) {
            partitionFieldStats = new ArrayList<PartitionFieldStats>();
        }
        return this.partitionFieldStats;
    }

    public Partition addPartitionFieldStats(PartitionFieldStats... partitionFieldStats) {
        getPartitionFieldStats().addAll(Arrays.asList(partitionFieldStats));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPartitionFieldStats()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPartitionFieldStats());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
