
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("ScoreDistribution")
@JsonPropertyOrder({
    "value",
    "recordCount",
    "confidence",
    "probability",
    "extensions"
})
public class ScoreDistribution
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ScoreDistribution>
{

    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlAttribute(name = "recordCount", required = true)
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("recordCount")
    private Number recordCount;
    @XmlAttribute(name = "confidence")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("confidence")
    private Number confidence;
    @XmlAttribute(name = "probability")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("probability")
    private Number probability;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371009L;

    public ScoreDistribution() {
    }

    @ValueConstructor
    public ScoreDistribution(
        @org.jpmml.model.annotations.Property("value")
        Object value,
        @org.jpmml.model.annotations.Property("recordCount")
        Number recordCount) {
        this.value = value;
        this.recordCount = recordCount;
    }

    public Object getValue() {
        return value;
    }

    public ScoreDistribution setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    public Number getRecordCount() {
        return recordCount;
    }

    public ScoreDistribution setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Number recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Number getConfidence() {
        return confidence;
    }

    public ScoreDistribution setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        Number confidence) {
        this.confidence = confidence;
        return this;
    }

    public Number getProbability() {
        return probability;
    }

    public ScoreDistribution setProbability(
        @org.jpmml.model.annotations.Property("probability")
        Number probability) {
        this.probability = probability;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ScoreDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
