
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "Theta", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "")
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("Theta")
@JsonPropertyOrder({
    "i",
    "j",
    "theta"
})
public class Theta
    extends PMMLObject
{

    @XmlAttribute(name = "i")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("i")
    private Integer i;
    @XmlAttribute(name = "j")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("j")
    private Integer j;
    @XmlAttribute(name = "theta")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("theta")
    private Number theta;
    private final static long serialVersionUID = 67371009L;

    public Integer getI() {
        return i;
    }

    public Theta setI(
        @Property("i")
        Integer i) {
        this.i = i;
        return this;
    }

    public Integer getJ() {
        return j;
    }

    public Theta setJ(
        @Property("j")
        Integer j) {
        this.j = j;
        return this;
    }

    public Number getTheta() {
        return theta;
    }

    public Theta setTheta(
        @Property("theta")
        Number theta) {
        this.theta = theta;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
