
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "ARIMA", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "nonseasonalComponent",
    "seasonalComponent",
    "dynamicRegressors",
    "maximumLikelihoodStat",
    "outlierEffects"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("ARIMA")
@JsonPropertyOrder({
    "rmse",
    "transformation",
    "constantTerm",
    "predictionMethod",
    "extensions",
    "nonseasonalComponent",
    "seasonalComponent",
    "dynamicRegressors",
    "maximumLikelihoodStat",
    "outlierEffects"
})
public class ARIMA
    extends TimeSeriesAlgorithm
    implements HasExtensions<ARIMA>
{

    @XmlAttribute(name = "RMSE")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("RMSE")
    private Number rmse;
    @XmlAttribute(name = "transformation")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("transformation")
    private String transformation;
    @XmlAttribute(name = "constantTerm")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("constantTerm")
    private Number constantTerm;
    @XmlAttribute(name = "predictionMethod")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("predictionMethod")
    private String predictionMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "NonseasonalComponent", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("NonseasonalComponent")
    private NonseasonalComponent nonseasonalComponent;
    @XmlElement(name = "SeasonalComponent", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("SeasonalComponent")
    private SeasonalComponent seasonalComponent;
    @XmlElement(name = "DynamicRegressor", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("DynamicRegressor")
    private List<DynamicRegressor> dynamicRegressors;
    @XmlElement(name = "MaximumLikelihoodStat", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("MaximumLikelihoodStat")
    private MaximumLikelihoodStat maximumLikelihoodStat;
    @XmlElement(name = "OutlierEffect", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("OutlierEffect")
    private List<OutlierEffect> outlierEffects;
    private final static Number DEFAULT_CONSTANT_TERM = new RealNumberAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371010L;

    public Number getRMSE() {
        return rmse;
    }

    public ARIMA setRMSE(
        @Property("rmse")
        Number rmse) {
        this.rmse = rmse;
        return this;
    }

    public String getTransformation() {
        if (transformation == null) {
            return "none";
        } else {
            return transformation;
        }
    }

    public ARIMA setTransformation(
        @Property("transformation")
        String transformation) {
        this.transformation = transformation;
        return this;
    }

    public Number getConstantTerm() {
        if (constantTerm == null) {
            return DEFAULT_CONSTANT_TERM;
        } else {
            return constantTerm;
        }
    }

    public ARIMA setConstantTerm(
        @Property("constantTerm")
        Number constantTerm) {
        this.constantTerm = constantTerm;
        return this;
    }

    public String getPredictionMethod() {
        if (predictionMethod == null) {
            return "conditionalLeastSquares";
        } else {
            return predictionMethod;
        }
    }

    public ARIMA setPredictionMethod(
        @Property("predictionMethod")
        String predictionMethod) {
        this.predictionMethod = predictionMethod;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ARIMA addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public NonseasonalComponent getNonseasonalComponent() {
        return nonseasonalComponent;
    }

    public ARIMA setNonseasonalComponent(
        @Property("nonseasonalComponent")
        NonseasonalComponent nonseasonalComponent) {
        this.nonseasonalComponent = nonseasonalComponent;
        return this;
    }

    public SeasonalComponent getSeasonalComponent() {
        return seasonalComponent;
    }

    public ARIMA setSeasonalComponent(
        @Property("seasonalComponent")
        SeasonalComponent seasonalComponent) {
        this.seasonalComponent = seasonalComponent;
        return this;
    }

    public boolean hasDynamicRegressors() {
        return ((this.dynamicRegressors!= null)&&(this.dynamicRegressors.size()> 0));
    }

    public List<DynamicRegressor> getDynamicRegressors() {
        if (dynamicRegressors == null) {
            dynamicRegressors = new ArrayList<DynamicRegressor>();
        }
        return this.dynamicRegressors;
    }

    public ARIMA addDynamicRegressors(DynamicRegressor... dynamicRegressors) {
        getDynamicRegressors().addAll(Arrays.asList(dynamicRegressors));
        return this;
    }

    public MaximumLikelihoodStat getMaximumLikelihoodStat() {
        return maximumLikelihoodStat;
    }

    public ARIMA setMaximumLikelihoodStat(
        @Property("maximumLikelihoodStat")
        MaximumLikelihoodStat maximumLikelihoodStat) {
        this.maximumLikelihoodStat = maximumLikelihoodStat;
        return this;
    }

    public boolean hasOutlierEffects() {
        return ((this.outlierEffects!= null)&&(this.outlierEffects.size()> 0));
    }

    public List<OutlierEffect> getOutlierEffects() {
        if (outlierEffects == null) {
            outlierEffects = new ArrayList<OutlierEffect>();
        }
        return this.outlierEffects;
    }

    public ARIMA addOutlierEffects(OutlierEffect... outlierEffects) {
        getOutlierEffects().addAll(Arrays.asList(outlierEffects));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getNonseasonalComponent(), getSeasonalComponent());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDynamicRegressors()) {
                status = PMMLObject.traverse(visitor, getDynamicRegressors());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMaximumLikelihoodStat());
            }
            if ((status == VisitorAction.CONTINUE)&&hasOutlierEffects()) {
                status = PMMLObject.traverse(visitor, getOutlierEffects());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
