
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "Target", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValues"
})
@JsonRootName("Target")
@JsonPropertyOrder({
    "field",
    "opType",
    "castInteger",
    "min",
    "max",
    "rescaleConstant",
    "rescaleFactor",
    "extensions",
    "targetValues"
})
public class Target
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Target> , HasFieldReference<Target> , HasOpType<Target> , Indexable<org.dmg.pmml.FieldName>
{

    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Optional((org.dmg.pmml.Version.PMML_4_3))
    @JsonProperty("field")
    private org.dmg.pmml.FieldName field;
    @XmlAttribute(name = "optype")
    @JsonProperty("optype")
    private OpType opType;
    @XmlAttribute(name = "castInteger")
    @JsonProperty("castInteger")
    private Target.CastInteger castInteger;
    @XmlAttribute(name = "min")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("min")
    private Number min;
    @XmlAttribute(name = "max")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("max")
    private Number max;
    @XmlAttribute(name = "rescaleConstant")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("rescaleConstant")
    private Number rescaleConstant;
    @XmlAttribute(name = "rescaleFactor")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("rescaleFactor")
    private Number rescaleFactor;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValue", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Optional((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("TargetValue")
    private List<TargetValue> targetValues;
    private final static Number DEFAULT_RESCALE_CONSTANT = new RealNumberAdapter().unmarshal("0");
    private final static Number DEFAULT_RESCALE_FACTOR = new RealNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371010L;

    @Override
    public org.dmg.pmml.FieldName getKey() {
        return getField();
    }

    @Override
    public org.dmg.pmml.FieldName getField() {
        return field;
    }

    @Override
    public Target setField(
        @Property("field")
        org.dmg.pmml.FieldName field) {
        this.field = field;
        return this;
    }

    @Override
    public OpType getOpType() {
        return opType;
    }

    @Override
    public Target setOpType(
        @Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    public Target.CastInteger getCastInteger() {
        return castInteger;
    }

    public Target setCastInteger(
        @Property("castInteger")
        Target.CastInteger castInteger) {
        this.castInteger = castInteger;
        return this;
    }

    public Number getMin() {
        return min;
    }

    public Target setMin(
        @Property("min")
        Number min) {
        this.min = min;
        return this;
    }

    public Number getMax() {
        return max;
    }

    public Target setMax(
        @Property("max")
        Number max) {
        this.max = max;
        return this;
    }

    public Number getRescaleConstant() {
        if (rescaleConstant == null) {
            return DEFAULT_RESCALE_CONSTANT;
        } else {
            return rescaleConstant;
        }
    }

    public Target setRescaleConstant(
        @Property("rescaleConstant")
        Number rescaleConstant) {
        this.rescaleConstant = rescaleConstant;
        return this;
    }

    public Number getRescaleFactor() {
        if (rescaleFactor == null) {
            return DEFAULT_RESCALE_FACTOR;
        } else {
            return rescaleFactor;
        }
    }

    public Target setRescaleFactor(
        @Property("rescaleFactor")
        Number rescaleFactor) {
        this.rescaleFactor = rescaleFactor;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Target addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTargetValues() {
        return ((this.targetValues!= null)&&(this.targetValues.size()> 0));
    }

    public List<TargetValue> getTargetValues() {
        if (targetValues == null) {
            targetValues = new ArrayList<TargetValue>();
        }
        return this.targetValues;
    }

    public Target addTargetValues(TargetValue... targetValues) {
        getTargetValues().addAll(Arrays.asList(targetValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTargetValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CastInteger
        implements StringValue<Target.CastInteger>
    {

        @XmlEnumValue("round")
        @JsonProperty("round")
        ROUND("round"),
        @XmlEnumValue("ceiling")
        @JsonProperty("ceiling")
        CEILING("ceiling"),
        @XmlEnumValue("floor")
        @JsonProperty("floor")
        FLOOR("floor");
        private final String value;

        CastInteger(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Target.CastInteger fromValue(String v) {
            for (Target.CastInteger c: Target.CastInteger.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
