
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "NumericInfo", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "quantiles"
})
@JsonRootName("NumericInfo")
@JsonPropertyOrder({
    "minimum",
    "maximum",
    "mean",
    "standardDeviation",
    "median",
    "interQuartileRange",
    "extensions",
    "quantiles"
})
public class NumericInfo
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<NumericInfo>
{

    @XmlAttribute(name = "minimum")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("minimum")
    private Number minimum;
    @XmlAttribute(name = "maximum")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("maximum")
    private Number maximum;
    @XmlAttribute(name = "mean")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("mean")
    private Number mean;
    @XmlAttribute(name = "standardDeviation")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("standardDeviation")
    private Number standardDeviation;
    @XmlAttribute(name = "median")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("median")
    private Number median;
    @XmlAttribute(name = "interQuartileRange")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("interQuartileRange")
    private Number interQuartileRange;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Quantile", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Quantile")
    private List<Quantile> quantiles;
    private final static long serialVersionUID = 67371266L;

    public Number getMinimum() {
        return minimum;
    }

    public NumericInfo setMinimum(
        @Property("minimum")
        Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public Number getMaximum() {
        return maximum;
    }

    public NumericInfo setMaximum(
        @Property("maximum")
        Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public Number getMean() {
        return mean;
    }

    public NumericInfo setMean(
        @Property("mean")
        Number mean) {
        this.mean = mean;
        return this;
    }

    public Number getStandardDeviation() {
        return standardDeviation;
    }

    public NumericInfo setStandardDeviation(
        @Property("standardDeviation")
        Number standardDeviation) {
        this.standardDeviation = standardDeviation;
        return this;
    }

    public Number getMedian() {
        return median;
    }

    public NumericInfo setMedian(
        @Property("median")
        Number median) {
        this.median = median;
        return this;
    }

    public Number getInterQuartileRange() {
        return interQuartileRange;
    }

    public NumericInfo setInterQuartileRange(
        @Property("interQuartileRange")
        Number interQuartileRange) {
        this.interQuartileRange = interQuartileRange;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NumericInfo addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasQuantiles() {
        return ((this.quantiles!= null)&&(this.quantiles.size()> 0));
    }

    public List<Quantile> getQuantiles() {
        if (quantiles == null) {
            quantiles = new ArrayList<Quantile>();
        }
        return this.quantiles;
    }

    public NumericInfo addQuantiles(Quantile... quantiles) {
        getQuantiles().addAll(Arrays.asList(quantiles));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasQuantiles()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getQuantiles());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
