
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BayesInputs", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "bayesInputs"
})
@JsonRootName("BayesInputs")
@JsonPropertyOrder({
    "extensions",
    "bayesInputs"
})
public class BayesInputs
    extends org.dmg.pmml.PMMLObject
    implements Iterable<BayesInput> , HasExtensions<BayesInputs>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "BayesInput", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("BayesInput")
    private List<BayesInput> bayesInputs;
    private final static long serialVersionUID = 67371266L;

    public BayesInputs() {
    }

    @ValueConstructor
    public BayesInputs(
        @Property("bayesInputs")
        List<BayesInput> bayesInputs) {
        this.bayesInputs = bayesInputs;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BayesInputs addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<BayesInput> iterator() {
        return getBayesInputs().iterator();
    }

    public boolean hasBayesInputs() {
        return ((this.bayesInputs!= null)&&(this.bayesInputs.size()> 0));
    }

    public List<BayesInput> getBayesInputs() {
        if (bayesInputs == null) {
            bayesInputs = new ArrayList<BayesInput>();
        }
        return this.bayesInputs;
    }

    public BayesInputs addBayesInputs(BayesInput... bayesInputs) {
        getBayesInputs().addAll(Arrays.asList(bayesInputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBayesInputs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBayesInputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
