
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasTable;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "instanceFields",
    "tableLocator",
    "inlineTable"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("TrainingInstances")
@JsonPropertyOrder({
    "transformed",
    "recordCount",
    "fieldCount",
    "extensions",
    "instanceFields",
    "tableLocator",
    "inlineTable"
})
public class TrainingInstances
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TrainingInstances> , HasTable<TrainingInstances>
{

    @XmlAttribute(name = "isTransformed")
    @JsonProperty("isTransformed")
    private Boolean transformed;
    @XmlAttribute(name = "recordCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("recordCount")
    private Integer recordCount;
    @XmlAttribute(name = "fieldCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("fieldCount")
    private Integer fieldCount;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "InstanceFields", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("InstanceFields")
    private InstanceFields instanceFields;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TableLocator")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("InlineTable")
    private InlineTable inlineTable;
    private final static Boolean DEFAULT_TRANSFORMED = false;
    private final static long serialVersionUID = 67371266L;

    public TrainingInstances() {
    }

    @ValueConstructor
    public TrainingInstances(
        @org.jpmml.model.annotations.Property("instanceFields")
        InstanceFields instanceFields,
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator,
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.instanceFields = instanceFields;
        this.tableLocator = tableLocator;
        this.inlineTable = inlineTable;
    }

    public boolean isTransformed() {
        if (transformed == null) {
            return DEFAULT_TRANSFORMED;
        } else {
            return transformed;
        }
    }

    public TrainingInstances setTransformed(
        @org.jpmml.model.annotations.Property("transformed")
        Boolean transformed) {
        this.transformed = transformed;
        return this;
    }

    public Integer getRecordCount() {
        return recordCount;
    }

    public TrainingInstances setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Integer recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Integer getFieldCount() {
        return fieldCount;
    }

    public TrainingInstances setFieldCount(
        @org.jpmml.model.annotations.Property("fieldCount")
        Integer fieldCount) {
        this.fieldCount = fieldCount;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TrainingInstances addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public InstanceFields getInstanceFields() {
        return instanceFields;
    }

    public TrainingInstances setInstanceFields(
        @org.jpmml.model.annotations.Property("instanceFields")
        InstanceFields instanceFields) {
        this.instanceFields = instanceFields;
        return this;
    }

    @Override
    public TableLocator getTableLocator() {
        return tableLocator;
    }

    @Override
    public TrainingInstances setTableLocator(
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    @Override
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    @Override
    public TrainingInstances setInlineTable(
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getInstanceFields(), getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
