
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "MA", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "maCoefficients",
    "residuals"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("MA")
@JsonPropertyOrder({
    "extensions",
    "maCoefficients",
    "residuals"
})
public class MA
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<MA>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MACoefficients", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MACoefficients")
    private MACoefficients maCoefficients;
    @XmlElement(name = "Residuals", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Residuals")
    private Residuals residuals;
    private final static long serialVersionUID = 67371266L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MA addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MACoefficients getMACoefficients() {
        return maCoefficients;
    }

    public MA setMACoefficients(
        @Property("maCoefficients")
        MACoefficients maCoefficients) {
        this.maCoefficients = maCoefficients;
        return this;
    }

    public Residuals getResiduals() {
        return residuals;
    }

    public MA setResiduals(
        @Property("residuals")
        Residuals residuals) {
        this.residuals = residuals;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMACoefficients(), getResiduals());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
